/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.rts;

import java.util.function.Supplier;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.rts.RTSSubsystemDefinition;
import org.wildfly.extension.rts.RTSSubsystemExtension;
import org.wildfly.extension.rts.configuration.Attribute;
import org.wildfly.extension.rts.deployment.InboundBridgeDeploymentProcessor;
import org.wildfly.extension.rts.logging.RTSLogger;
import org.wildfly.extension.rts.service.CoordinatorService;
import org.wildfly.extension.rts.service.InboundBridgeService;
import org.wildfly.extension.rts.service.ParticipantService;
import org.wildfly.extension.rts.service.VolatileParticipantService;
import org.wildfly.extension.undertow.Host;

final class RTSSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final RTSSubsystemAdd INSTANCE = new RTSSubsystemAdd();

    private RTSSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        RTSLogger.ROOT_LOGGER.trace("RTSSubsystemAdd.populateModel");
        RTSSubsystemDefinition.SERVER.validateAndSet(operation, model);
        RTSSubsystemDefinition.HOST.validateAndSet(operation, model);
        RTSSubsystemDefinition.SOCKET_BINDING.validateAndSet(operation, model);
    }

    public void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        RTSLogger.ROOT_LOGGER.trace("RTSSubsystemAdd.performBoottime");
        this.registerCoordinatorService(context, model);
        this.registerParticipantService(context, model);
        this.registerVolatileParticipantService(context, model);
        this.registerInboundBridgeService(context);
        this.registerDeploymentProcessors(context);
    }

    private void registerInboundBridgeService(OperationContext context) {
        InboundBridgeService inboundBridgeService = new InboundBridgeService();
        ServiceBuilder inboundBridgeServiceBuilder = context.getServiceTarget().addService(RTSSubsystemExtension.INBOUND_BRIDGE, (org.jboss.msc.service.Service)inboundBridgeService);
        inboundBridgeServiceBuilder.requires(context.getCapabilityServiceName("org.wildfly.transactions.xa-resource-recovery-registry", null));
        inboundBridgeServiceBuilder.requires(RTSSubsystemExtension.PARTICIPANT);
        inboundBridgeServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private void registerCoordinatorService(OperationContext context, ModelNode model) {
        String socketBindingName = model.get(Attribute.SOCKET_BINDING.getLocalName()).asString();
        String serverName = model.get(Attribute.SERVER.getLocalName()).asString();
        String hostName = model.get(Attribute.HOST.getLocalName()).asString();
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(RTSSubsystemDefinition.RTS_COORDINATOR_CAPABILITY);
        Supplier hostSupplier = builder.requiresCapability("org.wildfly.undertow.host", Host.class, new String[]{serverName, hostName});
        Supplier socketBindingSupplier = builder.requiresCapability("org.wildfly.network.socket-binding", SocketBinding.class, new String[]{socketBindingName});
        CoordinatorService coordinatorService = new CoordinatorService(hostSupplier, socketBindingSupplier);
        builder.setInstance((Service)coordinatorService).addAliases(new ServiceName[]{RTSSubsystemExtension.COORDINATOR}).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private void registerParticipantService(OperationContext context, ModelNode model) {
        String socketBindingName = model.get(Attribute.SOCKET_BINDING.getLocalName()).asString();
        String serverName = model.get(Attribute.SERVER.getLocalName()).asString();
        String hostName = model.get(Attribute.HOST.getLocalName()).asString();
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(RTSSubsystemDefinition.RTS_PARTICIPANT_CAPABILITY);
        Supplier hostSupplier = builder.requiresCapability("org.wildfly.undertow.host", Host.class, new String[]{serverName, hostName});
        Supplier socketBindingSupplier = builder.requiresCapability("org.wildfly.network.socket-binding", SocketBinding.class, new String[]{socketBindingName});
        ParticipantService participantService = new ParticipantService(hostSupplier, socketBindingSupplier);
        builder.setInstance((Service)participantService).addAliases(new ServiceName[]{RTSSubsystemExtension.PARTICIPANT}).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private void registerVolatileParticipantService(OperationContext context, ModelNode model) {
        String socketBindingName = model.get(Attribute.SOCKET_BINDING.getLocalName()).asString();
        String serverName = model.get(Attribute.SERVER.getLocalName()).asString();
        String hostName = model.get(Attribute.HOST.getLocalName()).asString();
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(RTSSubsystemDefinition.RTS_VOLATILE_PARTICIPANT_CAPABILITY);
        Supplier hostSupplier = builder.requiresCapability("org.wildfly.undertow.host", Host.class, new String[]{serverName, hostName});
        Supplier socketBindingSupplier = builder.requiresCapability("org.wildfly.network.socket-binding", SocketBinding.class, new String[]{socketBindingName});
        VolatileParticipantService volatileParticipantService = new VolatileParticipantService(hostSupplier, socketBindingSupplier);
        builder.setInstance((Service)volatileParticipantService).addAliases(new ServiceName[]{RTSSubsystemExtension.VOLATILE_PARTICIPANT}).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    private void registerDeploymentProcessors(OperationContext context) {
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("rts", Phase.POST_MODULE, 7424, (DeploymentUnitProcessor)new InboundBridgeDeploymentProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

