/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.aliases.impl.IndexAliasDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractNonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.work.result.impl.ExistingIndexMetadata;
import org.hibernate.search.util.common.AssertionFailure;

public class GetIndexMetadataWork
extends AbstractNonBulkableWork<List<ExistingIndexMetadata>> {
    private GetIndexMetadataWork(Builder builder) {
        super(builder);
    }

    @Override
    protected List<ExistingIndexMetadata> generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        JsonObject body = response.body();
        ArrayList<ExistingIndexMetadata> result = new ArrayList<ExistingIndexMetadata>();
        for (Map.Entry entry : body.entrySet()) {
            JsonObject indexAsObject = ((JsonElement)entry.getValue()).getAsJsonObject();
            IndexMetadata metadata = new IndexMetadata();
            metadata.setAliases(this.getAliases(context, indexAsObject));
            metadata.setSettings(this.getSettings(context, indexAsObject));
            metadata.setMapping(this.getMapping(context, indexAsObject));
            result.add(new ExistingIndexMetadata((String)entry.getKey(), metadata));
        }
        return result;
    }

    private Map<String, IndexAliasDefinition> getAliases(ElasticsearchWorkExecutionContext context, JsonObject index) {
        JsonElement aliases = index.get("aliases");
        if (aliases == null || !aliases.isJsonObject()) {
            throw new AssertionFailure("Elasticsearch API call succeeded, but the aliases weren't mentioned in the result: " + index);
        }
        GsonProvider gsonProvider = context.getGsonProvider();
        LinkedHashMap<String, IndexAliasDefinition> result = new LinkedHashMap<String, IndexAliasDefinition>();
        for (Map.Entry entry : aliases.getAsJsonObject().entrySet()) {
            IndexAliasDefinition aliasDefinition = (IndexAliasDefinition)gsonProvider.getGson().fromJson((JsonElement)entry.getValue(), IndexAliasDefinition.class);
            result.put((String)entry.getKey(), aliasDefinition);
        }
        return result;
    }

    private IndexSettings getSettings(ElasticsearchWorkExecutionContext context, JsonObject index) {
        JsonElement settings = index.get("settings");
        if (settings == null || !settings.isJsonObject()) {
            throw new AssertionFailure("Elasticsearch API call succeeded, but the requested settings weren't mentioned in the result: " + index);
        }
        JsonElement indexSettings = settings.getAsJsonObject().get("index");
        if (indexSettings != null) {
            GsonProvider gsonProvider = context.getGsonProvider();
            return (IndexSettings)gsonProvider.getGson().fromJson(indexSettings, IndexSettings.class);
        }
        return new IndexSettings();
    }

    private RootTypeMapping getMapping(ElasticsearchWorkExecutionContext context, JsonObject index) {
        JsonElement mappings = index.get("mappings");
        if (mappings != null) {
            GsonProvider gsonProvider = context.getGsonProvider();
            return (RootTypeMapping)gsonProvider.getGson().fromJson(mappings, RootTypeMapping.class);
        }
        return null;
    }

    public static class Builder
    extends AbstractNonBulkableWork.AbstractBuilder<Builder> {
        private final Set<URLEncodedString> indexNames = new LinkedHashSet<URLEncodedString>();

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
            super(ElasticsearchRequestSuccessAssessor.DEFAULT_INSTANCE);
        }

        public Builder index(URLEncodedString indexName) {
            this.indexNames.add(indexName);
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.get().multiValuedPathComponent(this.indexNames);
            builder.param("ignore_unavailable", true);
            builder.param("allow_no_indices", true);
            return builder.build();
        }

        public GetIndexMetadataWork build() {
            return new GetIndexMetadataWork(this);
        }
    }
}

