/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.util.EnumSet;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.metadata.EJBClientDescriptorMetaData;
import org.jboss.as.ee.structure.EJBClientDescriptor14Parser;
import org.jboss.as.ee.structure.EJBClientDescriptorXMLAttribute;
import org.jboss.as.ee.structure.EJBClientDescriptorXMLElement;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class EJBClientDescriptor15Parser
extends EJBClientDescriptor14Parser {
    public static final String NAMESPACE_1_5 = "urn:jboss:ejb-client:1.5";

    protected EJBClientDescriptor15Parser(PropertyReplacer propertyReplacer) {
        super(propertyReplacer);
    }

    @Override
    protected void parseCluster(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        EnumSet<EJBClientDescriptorXMLAttribute> required = EnumSet.of(EJBClientDescriptorXMLAttribute.NAME);
        int count = reader.getAttributeCount();
        String clusterName = null;
        String clusterNodeSelector = null;
        long connectTimeout = 5000L;
        long maxAllowedConnectedNodes = 10L;
        block15: for (int i = 0; i < count; ++i) {
            EJBClientDescriptorXMLAttribute attribute = EJBClientDescriptorXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            String value = this.readResolveValue(reader, i);
            switch (attribute) {
                case NAME: {
                    clusterName = value;
                    continue block15;
                }
                case CONNECT_TIMEOUT: {
                    connectTimeout = Long.parseLong(value);
                    continue block15;
                }
                case CLUSTER_NODE_SELECTOR: {
                    clusterNodeSelector = value;
                    continue block15;
                }
                case MAX_ALLOWED_CONNECTED_NODES: {
                    maxAllowedConnectedNodes = Long.parseLong(value);
                    continue block15;
                }
                default: {
                    EJBClientDescriptor15Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            EJBClientDescriptor15Parser.missingAttributes(reader.getLocation(), required);
        }
        EJBClientDescriptorMetaData.ClusterConfig clusterConfig = ejbClientDescriptorMetaData.newClusterConfig(clusterName);
        clusterConfig.setConnectTimeout(connectTimeout);
        clusterConfig.setNodeSelector(clusterNodeSelector);
        clusterConfig.setMaxAllowedConnectedNodes(maxAllowedConnectedNodes);
        block16: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    EJBClientDescriptorXMLElement element = EJBClientDescriptorXMLElement.forName(reader.getLocalName());
                    switch (element) {
                        case CONNECTION_CREATION_OPTIONS: {
                            Properties connectionCreationOptions = this.parseConnectionCreationOptions(reader);
                            clusterConfig.setConnectionOptions(connectionCreationOptions);
                            continue block16;
                        }
                        case CHANNEL_CREATION_OPTIONS: {
                            Properties channelCreationOptions = this.parseChannelCreationOptions(reader);
                            clusterConfig.setChannelCreationOptions(channelCreationOptions);
                            continue block16;
                        }
                        case NODE: {
                            this.parseClusterNode(reader, clusterConfig);
                            continue block16;
                        }
                    }
                    EJBClientDescriptor15Parser.unexpectedElement(reader);
                    continue block16;
                }
            }
            EJBClientDescriptor15Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor15Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    @Override
    protected void parseClusterNode(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData.ClusterConfig clusterConfig) throws XMLStreamException {
        EnumSet<EJBClientDescriptorXMLAttribute> required = EnumSet.of(EJBClientDescriptorXMLAttribute.NAME);
        int count = reader.getAttributeCount();
        String nodeName = null;
        long connectTimeout = 5000L;
        block12: for (int i = 0; i < count; ++i) {
            EJBClientDescriptorXMLAttribute attribute = EJBClientDescriptorXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            String value = this.readResolveValue(reader, i);
            switch (attribute) {
                case NAME: {
                    nodeName = value;
                    continue block12;
                }
                case CONNECT_TIMEOUT: {
                    connectTimeout = Long.parseLong(value);
                    continue block12;
                }
                default: {
                    EJBClientDescriptor15Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            EJBClientDescriptor15Parser.missingAttributes(reader.getLocation(), required);
        }
        EJBClientDescriptorMetaData.ClusterNodeConfig clusterNodeConfig = clusterConfig.newClusterNode(nodeName);
        clusterNodeConfig.setConnectTimeout(connectTimeout);
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    EJBClientDescriptorXMLElement element = EJBClientDescriptorXMLElement.forName(reader.getLocalName());
                    switch (element) {
                        case CONNECTION_CREATION_OPTIONS: {
                            Properties connectionCreationOptions = this.parseConnectionCreationOptions(reader);
                            clusterNodeConfig.setConnectionOptions(connectionCreationOptions);
                            continue block13;
                        }
                        case CHANNEL_CREATION_OPTIONS: {
                            Properties channelCreationOptions = this.parseChannelCreationOptions(reader);
                            clusterNodeConfig.setChannelCreationOptions(channelCreationOptions);
                            continue block13;
                        }
                    }
                    EJBClientDescriptor15Parser.unexpectedElement(reader);
                    continue block13;
                }
            }
            EJBClientDescriptor15Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor15Parser.unexpectedEndOfDocument(reader.getLocation());
    }
}

