/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.io.Serializable;
import org.hibernate.Internal;
import org.hibernate.type.Type;

@Internal
public final class BasicCacheKeyImplementation
implements Serializable {
    final Serializable id;
    private final String entityOrRoleName;
    private final int hashCode;

    @Internal
    public BasicCacheKeyImplementation(Object originalId, Serializable disassembledKey, Type type, String entityOrRoleName) {
        this(disassembledKey, entityOrRoleName, BasicCacheKeyImplementation.calculateHashCode(originalId, type));
    }

    @Internal
    public BasicCacheKeyImplementation(Serializable id, String entityOrRoleName, int hashCode) {
        assert (id != null);
        assert (entityOrRoleName != null);
        this.id = id;
        this.entityOrRoleName = entityOrRoleName;
        this.hashCode = hashCode;
    }

    private static int calculateHashCode(Object disassembledKey, Type type) {
        return type.getHashCode(disassembledKey);
    }

    public Object getId() {
        return this.id;
    }

    @Internal
    public String getEntityOrRoleName() {
        return this.entityOrRoleName;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other.getClass() != BasicCacheKeyImplementation.class) {
            return false;
        }
        BasicCacheKeyImplementation o = (BasicCacheKeyImplementation)other;
        return this.id.equals(o.id) && this.entityOrRoleName.equals(o.entityOrRoleName);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.entityOrRoleName + "#" + this.id.toString();
    }
}

