/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import jakarta.persistence.EntityManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.SharedSessionContract;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmMassEntityLoader;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmMassIdentifierLoader;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmMassLoadingOptions;
import org.hibernate.search.mapper.orm.loading.spi.ConditionalExpression;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmQueryLoader;
import org.hibernate.search.mapper.orm.loading.spi.LoadingTypeContext;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingMappingContext;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionTypeContextProvider;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassEntityLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassEntitySink;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassIdentifierSink;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingContext;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingEntityLoadingContext;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingIdentifierLoadingContext;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingLoadingStrategy;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingSessionContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public final class HibernateOrmMassIndexingContext
implements PojoMassIndexingContext,
HibernateOrmMassLoadingOptions {
    private final HibernateOrmMassIndexingMappingContext mappingContext;
    private final HibernateOrmSessionTypeContextProvider typeContextProvider;
    private final Map<Class<?>, ConditionalExpression> conditionalExpressions = new HashMap();
    private CacheMode cacheMode = CacheMode.IGNORE;
    private Integer idLoadingTransactionTimeout;
    private int idFetchSize = 100;
    private int objectLoadingBatchSize = 10;
    private long objectsLimit = 0L;

    public HibernateOrmMassIndexingContext(HibernateOrmMassIndexingMappingContext mappingContext, HibernateOrmSessionTypeContextProvider typeContextContainer) {
        this.mappingContext = mappingContext;
        this.typeContextProvider = typeContextContainer;
    }

    public <T> PojoMassIndexingLoadingStrategy<? super T, ?> loadingStrategy(PojoRawTypeIdentifier<T> expectedType) {
        LoadingTypeContext<T> typeContext = this.typeContextProvider.forExactType(expectedType);
        return new HibernateOrmMassIndexingLoadingStrategy(typeContext.loadingStrategy(), this.conditionalExpression(typeContext), this.typeContextProvider);
    }

    public void idLoadingTransactionTimeout(int timeoutInSeconds) {
        this.idLoadingTransactionTimeout = timeoutInSeconds;
    }

    @Override
    public Integer idLoadingTransactionTimeout() {
        return this.idLoadingTransactionTimeout;
    }

    public void cacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    @Override
    public CacheMode cacheMode() {
        return this.cacheMode;
    }

    public void objectLoadingBatchSize(int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("batchSize must be at least 1");
        }
        this.objectLoadingBatchSize = batchSize;
    }

    @Override
    public int objectLoadingBatchSize() {
        return this.objectLoadingBatchSize;
    }

    public void objectsLimit(long maximum) {
        this.objectsLimit = maximum;
    }

    @Override
    public long objectsLimit() {
        return this.objectsLimit;
    }

    public void idFetchSize(int idFetchSize) {
        this.idFetchSize = idFetchSize;
    }

    @Override
    public int idFetchSize() {
        return this.idFetchSize;
    }

    ConditionalExpression reindexOnly(Class<?> type, String conditionalExpression) {
        ConditionalExpression expression = new ConditionalExpression(conditionalExpression);
        this.conditionalExpressions.put(type, expression);
        return expression;
    }

    private Optional<ConditionalExpression> conditionalExpression(LoadingTypeContext<?> typeContext) {
        if (this.conditionalExpressions.isEmpty()) {
            return Optional.empty();
        }
        return typeContext.ascendingSuperTypes().stream().map(type -> this.conditionalExpressions.get(type.javaClass())).filter(Objects::nonNull).findFirst();
    }

    private final class HibernateOrmMassIndexingLoadingStrategy<E, I>
    implements PojoMassIndexingLoadingStrategy<E, I> {
        private final HibernateOrmEntityLoadingStrategy<E, I> delegate;
        private final Optional<ConditionalExpression> conditionalExpression;
        private final HibernateOrmSessionTypeContextProvider typeContextProvider;

        public HibernateOrmMassIndexingLoadingStrategy(HibernateOrmEntityLoadingStrategy<E, I> delegate, Optional<ConditionalExpression> conditionalExpression, HibernateOrmSessionTypeContextProvider typeContextProvider) {
            this.delegate = delegate;
            this.conditionalExpression = conditionalExpression;
            this.typeContextProvider = typeContextProvider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HibernateOrmMassIndexingLoadingStrategy that = (HibernateOrmMassIndexingLoadingStrategy)o;
            if (this.conditionalExpression.isPresent() || that.conditionalExpression.isPresent()) {
                return false;
            }
            return Objects.equals(this.delegate, that.delegate);
        }

        public int hashCode() {
            return Objects.hash(this.delegate, this.conditionalExpression);
        }

        public PojoMassIdentifierLoader createIdentifierLoader(PojoMassIndexingIdentifierLoadingContext<E, I> context) {
            SessionFactoryImplementor sessionFactory = HibernateOrmMassIndexingContext.this.mappingContext.sessionFactory();
            List<LoadingTypeContext<? extends E>> typeContexts = context.includedTypes().stream().map(this.typeContextProvider::forExactType).collect(Collectors.toList());
            HibernateOrmQueryLoader<? extends E, I> typeQueryLoader = this.createQueryLoader(typeContexts);
            SharedSessionContractImplementor session = (SharedSessionContractImplementor)sessionFactory.withStatelessOptions().tenantIdentifier((Object)context.tenantIdentifier()).openStatelessSession();
            try {
                PojoMassIdentifierSink sink = context.createSink();
                return new HibernateOrmMassIdentifierLoader<E, I>(typeQueryLoader, HibernateOrmMassIndexingContext.this, sink, session);
            }
            catch (RuntimeException e) {
                new SuppressingCloser((Throwable)e).push(SharedSessionContract::close, (Object)session);
                throw e;
            }
        }

        public PojoMassEntityLoader<I> createEntityLoader(PojoMassIndexingEntityLoadingContext<E> context) {
            SessionFactoryImplementor sessionFactory = HibernateOrmMassIndexingContext.this.mappingContext.sessionFactory();
            List<LoadingTypeContext<? extends E>> typeContexts = context.includedTypes().stream().map(this.typeContextProvider::forExactType).collect(Collectors.toList());
            HibernateOrmQueryLoader<? extends E, I> typeQueryLoader = this.createQueryLoader(typeContexts);
            SessionImplementor session = (SessionImplementor)sessionFactory.withOptions().tenantIdentifier((Object)context.tenantIdentifier()).openSession();
            try {
                session.setHibernateFlushMode(FlushMode.MANUAL);
                session.setCacheMode(HibernateOrmMassIndexingContext.this.cacheMode());
                session.setDefaultReadOnly(true);
                PojoMassEntitySink sink = context.createSink((PojoMassIndexingSessionContext)HibernateOrmMassIndexingContext.this.mappingContext.sessionContext((EntityManager)session));
                return new HibernateOrmMassEntityLoader(typeQueryLoader, HibernateOrmMassIndexingContext.this, sink, session);
            }
            catch (RuntimeException e) {
                new SuppressingCloser((Throwable)e).push(EntityManager::close, (Object)session);
                throw e;
            }
        }

        private HibernateOrmQueryLoader<E, I> createQueryLoader(List<LoadingTypeContext<? extends E>> typeContexts) {
            return this.delegate.createQueryLoader(typeContexts, this.conditionalExpression.isPresent() ? List.of(this.conditionalExpression.get()) : List.of());
        }
    }
}

