/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimitiveArray;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.spi.BindablePojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoModelPathBinder;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoModelPathWalker;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathDefinition;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathDefinitionProvider;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathEntityStateRepresentation;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

final class HibernateOrmPathInterpreter
implements PojoModelPathWalker<Context, Value, Property, Value> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final Set<String> PRIMITIVE_EXTRACTOR_NAMES = CollectionHelper.asImmutableSet((Object[])new String[]{"array-char", "array-boolean", "array-byte", "array-short", "array-int", "array-long", "array-float", "array-double"});

    HibernateOrmPathInterpreter() {
    }

    public PojoPathDefinition interpretPath(PojoRawTypeModel<?> typeModel, PersistentClass persistentClass, List<String> propertyStringRepresentationByOrdinal, PojoModelPathValueNode path) {
        Context context = new Context((PojoTypeModel<?>)typeModel, persistentClass, propertyStringRepresentationByOrdinal, path);
        Value value = (Value)PojoModelPathBinder.bind((Object)context, null, (PojoModelPathValueNode)path, (PojoModelPathWalker)this);
        if (!context.found) {
            throw log.unreportedPathForDirtyChecking((PojoModelPath)path, value);
        }
        return new PojoPathDefinition(context.stringRepresentations, Optional.ofNullable(context.entityStateRepresentation));
    }

    public Value type(Context context, Value valueNode) {
        return valueNode;
    }

    public Property property(Context context, Value parentValue, PojoModelPathPropertyNode pathNode) {
        if (context.found) {
            return null;
        }
        try {
            if (context.root) {
                context.root = false;
                return context.persistentClass.getProperty(pathNode.propertyName());
            }
            if (parentValue instanceof Component) {
                return ((Component)parentValue).getProperty(pathNode.propertyName());
            }
            throw log.unknownPathForDirtyChecking((PojoModelPath)pathNode, null);
        }
        catch (MappingException e) {
            throw log.unknownPathForDirtyChecking((PojoModelPath)pathNode, (Exception)((Object)e));
        }
    }

    public Value value(Context context, Property property, PojoModelPathValueNode path) {
        if (context.found) {
            return null;
        }
        boolean isWholePath = context.wholePath.equals((Object)path);
        Value baseValue = property.getValue();
        PojoModelPathPropertyNode propertyNode = path.parent();
        ContainerExtractorPath extractorPath = path.extractorPath();
        if (extractorPath.isDefault()) {
            throw new AssertionFailure("Expected a non-default extractor path as per the " + PojoPathDefinitionProvider.class.getSimpleName() + " contract");
        }
        Class<?> valueClass = baseValue.getClass();
        if (Component.class.isAssignableFrom(valueClass)) {
            if (!extractorPath.isEmpty()) {
                throw log.unknownPathForDirtyChecking((PojoModelPath)path, null);
            }
            if (isWholePath) {
                context.resolvedStringRepresentation(propertyNode.toPropertyString());
                context.disableStateRepresentation();
                return null;
            }
            context.pushComponent(propertyNode.propertyName());
            return baseValue;
        }
        if (BasicValue.class.isAssignableFrom(valueClass)) {
            context.resolvedStringRepresentation(propertyNode.toPropertyString());
            context.disableStateRepresentation();
            return null;
        }
        if (SimpleValue.class.isAssignableFrom(valueClass)) {
            if (isWholePath && HibernateOrmPathInterpreter.isSingleValuedAssociation(valueClass)) {
                String stringRepresentationAsProperty = propertyNode.toPropertyString();
                context.resolvedStringRepresentation(stringRepresentationAsProperty);
                this.resolveStateExtractorIfRelevant(context, stringRepresentationAsProperty, baseValue);
                return null;
            }
            return baseValue;
        }
        if (Collection.class.isAssignableFrom(valueClass)) {
            if (extractorPath.isEmpty() && !isWholePath) {
                throw log.unknownPathForDirtyChecking((PojoModelPath)path, null);
            }
            List extractorNames = extractorPath.explicitExtractorNames();
            Iterator<String> extractorNameIterator = extractorNames.iterator();
            return this.resolveExtractorPath(context, path, isWholePath, propertyNode, baseValue, extractorNameIterator);
        }
        throw log.unknownPathForDirtyChecking((PojoModelPath)path, null);
    }

    private Value resolveExtractorPath(Context context, PojoModelPathValueNode path, boolean isWholePath, PojoModelPathPropertyNode propertyNode, Value baseValue, Iterator<String> extractorNameIterator) {
        Collection collectionValue;
        Value containedValue = baseValue;
        do {
            collectionValue = (Collection)containedValue;
            try {
                String extractorName = extractorNameIterator.hasNext() ? extractorNameIterator.next() : null;
                containedValue = this.resolveExtractor(collectionValue, extractorName);
            }
            catch (SearchException e) {
                throw log.unknownPathForDirtyChecking((PojoModelPath)path, (Exception)((Object)e));
            }
        } while (extractorNameIterator.hasNext() && containedValue instanceof Collection);
        if (!extractorNameIterator.hasNext()) {
            Class<?> containedValueClass = containedValue.getClass();
            if (BasicValue.class.isAssignableFrom(containedValueClass) || Component.class.isAssignableFrom(containedValueClass) || isWholePath && HibernateOrmPathInterpreter.isAssociation(containedValueClass)) {
                String stringRepresentationAsProperty = propertyNode.toPropertyString();
                context.resolvedStringRepresentation(stringRepresentationAsProperty, collectionValue.getRole());
                this.resolveStateExtractorIfRelevant(context, stringRepresentationAsProperty, containedValue);
                return null;
            }
            return containedValue;
        }
        throw log.unknownPathForDirtyChecking((PojoModelPath)path, null);
    }

    private Value resolveExtractor(Collection collectionValue, String extractorName) {
        if (collectionValue instanceof PrimitiveArray) {
            if (extractorName == null || PRIMITIVE_EXTRACTOR_NAMES.contains(extractorName)) {
                return collectionValue.getElement();
            }
        } else if (collectionValue instanceof Array) {
            if (extractorName == null || "array-object".equals(extractorName)) {
                return collectionValue.getElement();
            }
        } else if (collectionValue instanceof Map) {
            if ("map-key".equals(extractorName)) {
                return ((Map)collectionValue).getIndex();
            }
            if (extractorName == null || "map-value".equals(extractorName)) {
                return collectionValue.getElement();
            }
        } else if (extractorName == null || "collection".equals(extractorName)) {
            return collectionValue.getElement();
        }
        throw log.invalidContainerExtractorForDirtyChecking(collectionValue.getClass(), extractorName);
    }

    private void resolveStateExtractorIfRelevant(Context context, String stringRepresentationAsProperty, Value value) {
        if (value instanceof OneToOne || value instanceof ManyToOne && ((ManyToOne)value).isLogicalOneToOne()) {
            String mappedBy = ((ToOne)value).getReferencedPropertyName();
            if (mappedBy == null || mappedBy.isEmpty()) {
                context.resolvedStateRepresentation(stringRepresentationAsProperty);
            } else {
                context.disableStateRepresentation();
            }
        } else {
            context.disableStateRepresentation();
        }
    }

    private static boolean isSingleValuedAssociation(Class<? extends Value> valueClass) {
        return ToOne.class.isAssignableFrom(valueClass) || Any.class.isAssignableFrom(valueClass);
    }

    private static boolean isAssociation(Class<? extends Value> valueClass) {
        return OneToMany.class.isAssignableFrom(valueClass) || ToOne.class.isAssignableFrom(valueClass) || Any.class.isAssignableFrom(valueClass);
    }

    static final class Context {
        private final PersistentClass persistentClass;
        private final PojoTypeModel<?> typeModel;
        private final List<String> propertyStringRepresentationByOrdinal;
        private final PojoModelPathValueNode wholePath;
        private boolean root = true;
        private final Set<String> stringRepresentations = new LinkedHashSet<String>();
        private String rootComponentPropertyName;
        private PojoPathEntityStateRepresentation entityStateRepresentation = null;
        private boolean found = false;

        private Context(PojoTypeModel<?> typeModel, PersistentClass persistentClass, List<String> propertyStringRepresentationByOrdinal, PojoModelPathValueNode wholePath) {
            this.typeModel = typeModel;
            this.persistentClass = persistentClass;
            this.propertyStringRepresentationByOrdinal = propertyStringRepresentationByOrdinal;
            this.wholePath = wholePath;
        }

        public void resolvedStringRepresentation(String ... stringRepresentationArray) {
            this.found = true;
            Collections.addAll(this.stringRepresentations, stringRepresentationArray);
        }

        void pushComponent(String propertyName) {
            if (this.rootComponentPropertyName == null) {
                this.rootComponentPropertyName = propertyName;
            }
        }

        public void disableStateRepresentation() {
            this.entityStateRepresentation = null;
        }

        public void resolvedStateRepresentation(String wholePathStringRepresentation) {
            try {
                this.tryResolveStateRepresentation(wholePathStringRepresentation);
            }
            catch (RuntimeException e) {
                log.failedToResolveStateRepresentation(wholePathStringRepresentation, EventContexts.fromType(this.typeModel).append(PojoEventContexts.fromPath((PojoModelPath)this.wholePath)), e.getMessage(), e);
                this.disableStateRepresentation();
            }
        }

        public void tryResolveStateRepresentation(String wholePathStringRepresentation) {
            Optional<Object> pathFromStateArrayElement;
            String propertyStringRepresentationForOrdinal;
            if (this.rootComponentPropertyName == null) {
                propertyStringRepresentationForOrdinal = wholePathStringRepresentation;
                pathFromStateArrayElement = Optional.empty();
            } else {
                propertyStringRepresentationForOrdinal = this.rootComponentPropertyName;
                PojoModelPathValueNode rootComponentPath = PojoModelPath.ofValue((String)this.rootComponentPropertyName, (ContainerExtractorPath)ContainerExtractorPath.noExtractors());
                Optional unboundPathFromRootComponent = this.wholePath.relativize(rootComponentPath);
                if (!unboundPathFromRootComponent.isPresent()) {
                    throw new AssertionFailure("Cannot relativize '" + rootComponentPath + "' to '" + this.wholePath + "'.");
                }
                pathFromStateArrayElement = Optional.of(new BindablePojoModelPath(this.typeModel.property(this.rootComponentPropertyName).typeModel(), (PojoModelPathValueNode)unboundPathFromRootComponent.get()));
            }
            int ordinalInStateArray = this.propertyStringRepresentationByOrdinal.indexOf(propertyStringRepresentationForOrdinal);
            if (ordinalInStateArray < 0) {
                throw new AssertionFailure("Cannot find ordinal in state array for path '" + propertyStringRepresentationForOrdinal + "'. Available paths are: " + this.propertyStringRepresentationByOrdinal + ".");
            }
            this.entityStateRepresentation = new PojoPathEntityStateRepresentation(ordinalInStateArray, pathFromStateArrayElement);
        }
    }
}

