/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.cfg.impl;

import java.lang.invoke.MethodHandles;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.type.descriptor.JdbcTypeNameMapper;

public final class UuidDataTypeUtils {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String DEFAULT = "default";
    @Deprecated
    private static final String UUID_BINARY = "uuid-binary";
    @Deprecated
    private static final String UUID_CHAR = "uuid-char";

    private UuidDataTypeUtils() {
    }

    public static int uuidType(String value, ConfigurationPropertySource source, OptionalConfigurationProperty<String> property, Dialect dialect) {
        if (DEFAULT.equalsIgnoreCase(value)) {
            return UuidDataTypeUtils.defaultUuidType(dialect);
        }
        String propertyName = property.resolveOrRaw(source);
        if (UUID_CHAR.equalsIgnoreCase(value)) {
            log.usingDeprecatedPropertyValue(propertyName, value, "CHAR");
            return 1;
        }
        if (UUID_BINARY.equalsIgnoreCase(value)) {
            log.usingDeprecatedPropertyValue(propertyName, value, "BINARY");
            return -2;
        }
        return TypeCodeConverter.convert(value);
    }

    public static int defaultUuidType(Dialect dialect) {
        if (dialect instanceof SQLServerDialect) {
            return -2;
        }
        return 1;
    }

    private static class TypeCodeConverter {
        private TypeCodeConverter() {
        }

        public static int convert(String value) {
            String string = value.toUpperCase(Locale.ROOT);
            Integer typeCode = JdbcTypeNameMapper.getTypeCode((String)string);
            if (typeCode != null) {
                return typeCode;
            }
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException ex) {
                throw log.unableToParseJdbcTypeCode(value, ex.getMessage(), ex);
            }
        }
    }
}

