/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.common.spi.TransactionHelper;
import org.hibernate.search.mapper.orm.coordination.common.spi.CoordinationStrategyStartContext;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEvent;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxPollingOutboxEventAdditionalJaxbMappingProducer;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.Log;
import org.hibernate.search.mapper.orm.outboxpolling.mapping.OutboxPollingSearchMapping;
import org.hibernate.search.mapper.orm.tenancy.spi.TenancyConfiguration;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class OutboxPollingSearchMappingImpl
implements OutboxPollingSearchMapping {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String COUNT_EVENTS_WITH_STATUS = "select count(e) from " + OutboxPollingOutboxEventAdditionalJaxbMappingProducer.ENTITY_NAME + " e where e.status = :status";
    private static final String UPDATE_EVENTS_WITH_STATUS = "update " + OutboxPollingOutboxEventAdditionalJaxbMappingProducer.ENTITY_NAME + " e set e.status = :newStatus where e.status = :status";
    private static final String DELETE_EVENTS_WITH_STATUS = "delete " + OutboxPollingOutboxEventAdditionalJaxbMappingProducer.ENTITY_NAME + " e where e.status = :status";
    private final TransactionHelper transactionHelper;
    private final SessionFactoryImplementor sessionFactory;
    private final TenancyConfiguration tenancyConfiguration;
    private final Set<String> tenantIds;

    public OutboxPollingSearchMappingImpl(CoordinationStrategyStartContext context, TenancyConfiguration tenancyConfiguration) {
        this.sessionFactory = context.mapping().sessionFactory();
        this.transactionHelper = new TransactionHelper(this.sessionFactory, null);
        this.tenancyConfiguration = tenancyConfiguration;
        this.tenantIds = this.tenancyConfiguration.tenantIdsOrFail();
    }

    @Override
    public long countAbortedEvents() {
        this.checkNoTenant();
        try (SessionImplementor session = this.sessionFactory.openSession();){
            long l = (Long)this.transactionHelper.inTransaction((SharedSessionContractImplementor)session, () -> OutboxPollingSearchMappingImpl.lambda$countAbortedEvents$0((Session)session));
            return l;
        }
    }

    @Override
    public long countAbortedEvents(String tenantId) {
        this.checkTenant(tenantId);
        try (Session session = this.sessionFactory.withOptions().tenantIdentifier((Object)tenantId).openSession();){
            long l = (Long)this.transactionHelper.inTransaction((SharedSessionContractImplementor)session, () -> {
                Query query = session.createQuery(COUNT_EVENTS_WITH_STATUS, Long.class);
                query.setParameter("status", (Object)OutboxEvent.Status.ABORTED);
                return (Long)query.getSingleResult();
            });
            return l;
        }
    }

    @Override
    public int reprocessAbortedEvents() {
        this.checkNoTenant();
        try (SessionImplementor session = this.sessionFactory.openSession();){
            int n = (Integer)this.transactionHelper.inTransaction((SharedSessionContractImplementor)session, () -> OutboxPollingSearchMappingImpl.lambda$reprocessAbortedEvents$2((Session)session));
            return n;
        }
    }

    @Override
    public int reprocessAbortedEvents(String tenantId) {
        this.checkTenant(tenantId);
        try (Session session = this.sessionFactory.withOptions().tenantIdentifier((Object)tenantId).openSession();){
            int n = (Integer)this.transactionHelper.inTransaction((SharedSessionContractImplementor)session, () -> {
                MutationQuery query = session.createMutationQuery(UPDATE_EVENTS_WITH_STATUS);
                query.setParameter("status", (Object)OutboxEvent.Status.ABORTED);
                query.setParameter("newStatus", (Object)OutboxEvent.Status.PENDING);
                return query.executeUpdate();
            });
            return n;
        }
    }

    @Override
    public int clearAllAbortedEvents() {
        this.checkNoTenant();
        try (SessionImplementor session = this.sessionFactory.openSession();){
            int n = (Integer)this.transactionHelper.inTransaction((SharedSessionContractImplementor)session, () -> OutboxPollingSearchMappingImpl.lambda$clearAllAbortedEvents$4((Session)session));
            return n;
        }
    }

    @Override
    public int clearAllAbortedEvents(String tenantId) {
        this.checkTenant(tenantId);
        try (Session session = this.sessionFactory.withOptions().tenantIdentifier((Object)tenantId).openSession();){
            int n = (Integer)this.transactionHelper.inTransaction((SharedSessionContractImplementor)session, () -> {
                MutationQuery query = session.createMutationQuery(DELETE_EVENTS_WITH_STATUS);
                query.setParameter("status", (Object)OutboxEvent.Status.ABORTED);
                return query.executeUpdate();
            });
            return n;
        }
    }

    private void checkNoTenant() {
        if (!this.tenantIds.isEmpty()) {
            throw log.noTenantIdSpecified(this.tenantIds);
        }
    }

    private void checkTenant(String tenantId) {
        if (this.tenantIds.isEmpty()) {
            throw log.multiTenancyNotEnabled(tenantId);
        }
        if (!this.tenantIds.contains(tenantId)) {
            throw this.tenancyConfiguration.invalidTenantId(tenantId);
        }
    }

    private static /* synthetic */ Integer lambda$clearAllAbortedEvents$4(Session session) {
        MutationQuery query = session.createMutationQuery(DELETE_EVENTS_WITH_STATUS);
        query.setParameter("status", (Object)OutboxEvent.Status.ABORTED);
        return query.executeUpdate();
    }

    private static /* synthetic */ Integer lambda$reprocessAbortedEvents$2(Session session) {
        MutationQuery query = session.createMutationQuery(UPDATE_EVENTS_WITH_STATUS);
        query.setParameter("status", (Object)OutboxEvent.Status.ABORTED);
        query.setParameter("newStatus", (Object)OutboxEvent.Status.PENDING);
        return query.executeUpdate();
    }

    private static /* synthetic */ Long lambda$countAbortedEvents$0(Session session) {
        Query query = session.createQuery(COUNT_EVENTS_WITH_STATUS, Long.class);
        query.setParameter("status", (Object)OutboxEvent.Status.ABORTED);
        return (Long)query.getSingleResult();
    }
}

