/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.service;

import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.common.function.Functions;
import org.wildfly.service.AsyncServiceBuilder;
import org.wildfly.service.Installer;
import org.wildfly.service.ServiceDependency;

public interface ServiceInstaller
extends Installer<ServiceTarget> {
    public static <V> Builder<V, V> builder(V value) {
        return (Builder)ServiceInstaller.builder(Functions.constantSupplier(value)).asActive();
    }

    public static <V> Builder<V, V> builder(ServiceDependency<V> dependency) {
        return (Builder)((Builder)ServiceInstaller.builder(dependency).withDependency(dependency)).asPassive();
    }

    public static <V> Builder<V, V> builder(Supplier<V> factory) {
        return ServiceInstaller.builder(Function.identity(), factory);
    }

    public static <T, V> Builder<T, V> builder(Function<T, V> mapper, Supplier<T> factory) {
        return new DefaultServiceInstaller.Builder<T, V>(mapper, factory);
    }

    public static class DefaultServiceInstaller<T, V>
    extends AbstractServiceInstaller<T, V>
    implements ServiceInstaller {
        DefaultServiceInstaller(Installer.Configuration<ServiceBuilder<?>, ServiceBuilder<?>, T, V> config) {
            super(config);
        }

        static class Builder<T, V>
        extends AbstractServiceInstaller.Builder<org.wildfly.service.ServiceInstaller$Builder<T, V>, ServiceInstaller, T, V>
        implements org.wildfly.service.ServiceInstaller$Builder<T, V> {
            private volatile Supplier<Executor> executor = null;
            private volatile AsyncServiceBuilder.Async async = AsyncServiceBuilder.Async.START_ONLY;

            Builder(Function<T, V> mapper, Supplier<T> factory) {
                super(mapper, factory);
            }

            @Override
            public UnaryOperator<ServiceBuilder<?>> getServiceBuilderDecorator() {
                final Supplier<Executor> executor = this.executor;
                final AsyncServiceBuilder.Async async = this.async;
                return executor == null ? UnaryOperator.identity() : new UnaryOperator<ServiceBuilder<?>>(){

                    @Override
                    public ServiceBuilder<?> apply(ServiceBuilder<?> builder) {
                        return new AsyncServiceBuilder(builder, executor, async);
                    }
                };
            }

            @Override
            public org.wildfly.service.ServiceInstaller$Builder<T, V> async(Supplier<Executor> executor) {
                this.executor = executor;
                return this;
            }

            @Override
            public org.wildfly.service.ServiceInstaller$Builder<T, V> onStop(Consumer<T> consumer) {
                this.async = AsyncServiceBuilder.Async.START_AND_STOP;
                return (org.wildfly.service.ServiceInstaller$Builder)super.onStop(consumer);
            }

            @Override
            public ServiceInstaller build() {
                return new DefaultServiceInstaller(this);
            }

            @Override
            protected org.wildfly.service.ServiceInstaller$Builder<T, V> builder() {
                return this;
            }
        }
    }

    public static abstract class AbstractServiceInstaller<T, V>
    extends Installer.AbstractInstaller<ServiceTarget, ServiceBuilder<?>, ServiceBuilder<?>, T, V> {
        private static final Function<ServiceTarget, ServiceBuilder<?>> FACTORY = ServiceTarget::addService;

        protected AbstractServiceInstaller(Installer.Configuration<ServiceBuilder<?>, ServiceBuilder<?>, T, V> config) {
            super(config, FACTORY);
        }

        protected static abstract class Builder<B, I extends Installer<ServiceTarget>, T, V>
        extends Installer.AbstractInstaller.Builder<B, I, ServiceTarget, ServiceBuilder<?>, ServiceBuilder<?>, T, V> {
            protected Builder(Function<T, V> mapper, Supplier<T> factory) {
                super(mapper, factory);
            }
        }
    }

    public static interface Builder<T, V>
    extends Installer.Builder<Builder<T, V>, ServiceInstaller, ServiceTarget, ServiceBuilder<?>, T, V> {
        public Builder<T, V> async(Supplier<Executor> var1);
    }
}

