/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicNameValuePair;
import org.wildfly.security.http.oidc.ClientCredentialsProvider;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcClientConfiguration;

public class ClientCredentialsProviderUtils {
    public static ClientCredentialsProvider bootstrapClientAuthenticator(OidcClientConfiguration oidcClientConfiguration) {
        String authenticatorId;
        String clientId = oidcClientConfiguration.getResourceName();
        Map<String, Object> clientCredentials = oidcClientConfiguration.getResourceCredentials();
        if (clientCredentials == null || clientCredentials.isEmpty()) {
            authenticatorId = Oidc.ClientCredentialsProviderType.SECRET.getValue();
        } else {
            authenticatorId = (String)clientCredentials.get("provider");
            if (authenticatorId == null) {
                if (clientCredentials.size() == 1) {
                    authenticatorId = clientCredentials.keySet().iterator().next();
                } else {
                    throw ElytronMessages.log.unableToDetermineClientCredentialsProviderType(oidcClientConfiguration.getResourceName());
                }
            }
        }
        ElytronMessages.log.debugf("Using provider '%s' for authentication of client '%s'", authenticatorId, clientId);
        HashMap<String, ClientCredentialsProvider> authenticators = new HashMap<String, ClientCredentialsProvider>();
        ClientCredentialsProviderUtils.loadAuthenticators(authenticators, ClientCredentialsProviderUtils.class.getClassLoader());
        ClientCredentialsProviderUtils.loadAuthenticators(authenticators, Thread.currentThread().getContextClassLoader());
        ClientCredentialsProvider authenticator = (ClientCredentialsProvider)authenticators.get(authenticatorId);
        if (authenticator == null) {
            throw ElytronMessages.log.unableToFindClientCredentialsProvider(authenticatorId);
        }
        Object config = clientCredentials == null ? null : clientCredentials.get(authenticatorId);
        authenticator.init(oidcClientConfiguration, config);
        return authenticator;
    }

    private static void loadAuthenticators(Map<String, ClientCredentialsProvider> authenticators, ClassLoader classLoader) {
        Iterator<ClientCredentialsProvider> iterator = ServiceLoader.load(ClientCredentialsProvider.class, classLoader).iterator();
        while (iterator.hasNext()) {
            try {
                ClientCredentialsProvider authenticator = iterator.next();
                ElytronMessages.log.debugf("Loaded clientCredentialsProvider %s", authenticator.getId());
                authenticators.put(authenticator.getId(), authenticator);
            }
            catch (ServiceConfigurationError e) {
                ElytronMessages.log.debugf("Failed to load clientCredentialsProvider with classloader: " + classLoader, e);
            }
        }
    }

    public static void setClientCredentials(OidcClientConfiguration oidcClientConfiguration, Map<String, String> requestHeaders, Map<String, String> formparams) {
        ClientCredentialsProvider authenticator = oidcClientConfiguration.getClientAuthenticator();
        authenticator.setClientCredentials(oidcClientConfiguration, requestHeaders, formparams);
    }

    public static void setClientCredentials(OidcClientConfiguration oidcClientConfiguration, HttpPost post, List<NameValuePair> formparams) {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        HashMap<String, String> reqParams = new HashMap<String, String>();
        ClientCredentialsProviderUtils.setClientCredentials(oidcClientConfiguration, reqHeaders, reqParams);
        for (Map.Entry header : reqHeaders.entrySet()) {
            post.setHeader((String)header.getKey(), (String)header.getValue());
        }
        for (Map.Entry param : reqParams.entrySet()) {
            formparams.add((NameValuePair)new BasicNameValuePair((String)param.getKey(), (String)param.getValue()));
        }
    }
}

