/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.service.capture;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capture.FunctionExecutor;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;
import org.wildfly.subsystem.service.capture.ServiceValueRegistry;

public interface ServiceValueExecutorRegistry<V>
extends ServiceValueRegistry<V>,
FunctionExecutorRegistry<V> {
    public static <V> ServiceValueExecutorRegistry<V> create() {
        return new ServiceValueExecutorRegistry<V>(){
            private final Map<ServiceDependency<V>, AtomicReference<V>> references = new ConcurrentHashMap();

            private AtomicReference<V> create(ServiceDependency<V> dependency) {
                return new AtomicReference();
            }

            @Override
            public Consumer<V> add(ServiceDependency<V> dependency) {
                AtomicReference reference = this.references.computeIfAbsent(dependency, this::create);
                return reference::set;
            }

            @Override
            public void remove(ServiceDependency<V> dependency) {
                AtomicReference<Object> reference = this.references.remove(dependency);
                if (reference != null) {
                    reference.set(null);
                }
            }

            @Override
            public FunctionExecutor<V> getExecutor(ServiceDependency<V> dependency) {
                AtomicReference reference = this.references.get(dependency);
                return reference != null ? FunctionExecutor.of(reference::get) : null;
            }
        };
    }
}

