/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.publisher;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jboss.resteasy.concurrent.ContextualExecutorService;
import org.jboss.resteasy.concurrent.ContextualExecutors;
import org.jboss.resteasy.microprofile.client.publisher.SSEPublisher;
import org.jboss.resteasy.plugins.providers.sse.SseEventInputImpl;
import org.reactivestreams.Publisher;

@Provider
@Consumes(value={"text/event-stream"})
public class MpPublisherMessageBodyReader
implements MessageBodyReader<Publisher<?>> {
    @Context
    protected Providers providers;
    private final ContextualExecutorService executor;

    public MpPublisherMessageBodyReader(ExecutorService ex) {
        this.executor = ContextualExecutors.wrap((ExecutorService)ex);
    }

    public MpPublisherMessageBodyReader() {
        this.executor = ContextualExecutors.threadPool();
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Publisher.class.isAssignableFrom(type) && MediaType.SERVER_SENT_EVENTS_TYPE.isCompatible(mediaType);
    }

    public Publisher<?> readFrom(Class<Publisher<?>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws WebApplicationException {
        Map map;
        String elementType;
        MediaType streamType = mediaType;
        if (mediaType.getParameters() != null && (elementType = (String)(map = mediaType.getParameters()).get("element-type")) != null) {
            streamType = MediaType.valueOf((String)elementType);
        }
        SseEventInputImpl sseEventInput = new SseEventInputImpl(annotations, streamType, mediaType, httpHeaders, entityStream);
        return new SSEPublisher(genericType, this.providers, sseEventInput, (ExecutorService)this.executor);
    }
}

