/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.resources.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.util.common.impl.Closer;

public class EngineThreads {
    private final ThreadPoolProvider threadPoolProvider;
    private ScheduledExecutorService timingExecutor;

    public EngineThreads(ThreadPoolProvider threadPoolProvider) {
        this.threadPoolProvider = threadPoolProvider;
    }

    public void onStop() {
        try (Closer closer = new Closer();){
            closer.push(ExecutorService::shutdownNow, (Object)this.timingExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledExecutorService getTimingExecutor() {
        ScheduledExecutorService executor = this.timingExecutor;
        if (executor != null) {
            return executor;
        }
        EngineThreads engineThreads = this;
        synchronized (engineThreads) {
            if (this.timingExecutor != null) {
                return this.timingExecutor;
            }
            this.timingExecutor = this.threadPoolProvider.newScheduledExecutor(1, "Engine - Timing thread");
            return this.timingExecutor;
        }
    }
}

