/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.spatial.impl;

import java.lang.invoke.MethodHandles;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.mapper.pojo.bridge.PropertyBridge;
import org.hibernate.search.mapper.pojo.bridge.TypeBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.PropertyBindingContext;
import org.hibernate.search.mapper.pojo.bridge.binding.TypeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.builtin.programmatic.GeoPointBinder;
import org.hibernate.search.mapper.pojo.bridge.builtin.spatial.impl.LatitudeMarker;
import org.hibernate.search.mapper.pojo.bridge.builtin.spatial.impl.LongitudeMarker;
import org.hibernate.search.mapper.pojo.bridge.runtime.PropertyBridgeWriteContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.TypeBridgeWriteContext;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.PojoElementAccessor;
import org.hibernate.search.mapper.pojo.model.PojoModelCompositeElement;
import org.hibernate.search.util.common.impl.StreamHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class GeoPointBridge
implements TypeBridge<Object>,
PropertyBridge<Object> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Function<Object, GeoPoint> coordinatesExtractor;
    private final IndexFieldReference<GeoPoint> indexFieldReference;

    private GeoPointBridge(Function<Object, GeoPoint> coordinatesExtractor, IndexFieldReference<GeoPoint> indexFieldReference) {
        this.coordinatesExtractor = coordinatesExtractor;
        this.indexFieldReference = indexFieldReference;
    }

    @Override
    public void write(DocumentElement target, Object bridgedElement, TypeBridgeWriteContext context) {
        this.doWrite(target, bridgedElement);
    }

    @Override
    public void write(DocumentElement target, Object bridgedElement, PropertyBridgeWriteContext context) {
        this.doWrite(target, bridgedElement);
    }

    private void doWrite(DocumentElement target, Object bridgedElement) {
        GeoPoint coordinates = this.coordinatesExtractor.apply(bridgedElement);
        target.addValue(this.indexFieldReference, (Object)coordinates);
    }

    @Override
    public void close() {
    }

    public static class Binder
    implements GeoPointBinder {
        private String fieldName;
        private Projectable projectable = Projectable.DEFAULT;
        private Sortable sortable = Sortable.DEFAULT;
        private String markerSet;

        @Override
        public Binder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        @Override
        public Binder projectable(Projectable projectable) {
            this.projectable = projectable;
            return this;
        }

        @Override
        public Binder sortable(Sortable sortable) {
            this.sortable = sortable;
            return this;
        }

        @Override
        public Binder markerSet(String markerSet) {
            this.markerSet = markerSet;
            return this;
        }

        @Override
        public void bind(TypeBindingContext context) {
            if (this.fieldName == null || this.fieldName.isEmpty()) {
                throw log.missingFieldNameForGeoPointBridgeOnType(context.bridgedElement().toString());
            }
            GeoPointBridge bridge = this.doBind(this.fieldName, context.typeFactory(), context.indexSchemaElement(), context.bridgedElement());
            context.bridge(bridge);
        }

        @Override
        public void bind(PropertyBindingContext context) {
            String defaultedFieldName = this.fieldName != null && !this.fieldName.isEmpty() ? this.fieldName : context.bridgedElement().name();
            GeoPointBridge bridge = this.doBind(defaultedFieldName, context.typeFactory(), context.indexSchemaElement(), context.bridgedElement());
            context.bridge(bridge);
        }

        private GeoPointBridge doBind(String defaultedFieldName, IndexFieldTypeFactory typeFactory, IndexSchemaElement indexSchemaElement, PojoModelCompositeElement bridgedPojoModelElement) {
            IndexFieldReference indexFieldReference = (IndexFieldReference)indexSchemaElement.field(defaultedFieldName, typeFactory.asGeoPoint().projectable(this.projectable).sortable(this.sortable).toIndexFieldType()).toReference();
            PojoElementAccessor<Double> latitudeAccessor = bridgedPojoModelElement.properties().stream().filter(model -> model.markers(LatitudeMarker.class).stream().map(LatitudeMarker::getMarkerSet).anyMatch(Predicate.isEqual(this.markerSet))).collect(Binder.singleMarkedProperty("@Latitude", defaultedFieldName, this.markerSet)).createAccessor(Double.class);
            PojoElementAccessor<Double> longitudeAccessor = bridgedPojoModelElement.properties().stream().filter(model -> model.markers(LongitudeMarker.class).stream().map(LongitudeMarker::getMarkerSet).anyMatch(Predicate.isEqual(this.markerSet))).collect(Binder.singleMarkedProperty("@Longitude", defaultedFieldName, this.markerSet)).createAccessor(Double.class);
            Function<Object, GeoPoint> coordinatesExtractor = bridgedElement -> {
                Double latitude = (Double)latitudeAccessor.read(bridgedElement);
                Double longitude = (Double)longitudeAccessor.read(bridgedElement);
                if (latitude == null || longitude == null) {
                    return null;
                }
                return GeoPoint.of((double)latitude, (double)longitude);
            };
            return new GeoPointBridge(coordinatesExtractor, (IndexFieldReference<GeoPoint>)indexFieldReference);
        }

        private static Collector<PojoModelCompositeElement, ?, PojoModelCompositeElement> singleMarkedProperty(String markerName, String fieldName, String markerSet) {
            return StreamHelper.singleElement(() -> log.unableToFindLongitudeOrLatitudeProperty(markerName, fieldName, markerSet), () -> log.multipleLatitudeOrLongitudeProperties(markerName, fieldName, markerSet));
        }
    }
}

