/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.service;

import com.arjuna.ats.arjuna.common.CoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.CoreEnvironmentBeanException;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.utils.Process;
import com.arjuna.ats.internal.arjuna.utils.UuidProcessId;
import java.util.function.Supplier;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class CoreEnvironmentService
implements Service<CoreEnvironmentBean> {
    private final Supplier<SocketBinding> socketBindingSupplier;
    private final String nodeIdentifier;

    public CoreEnvironmentService(String nodeIdentifier, Supplier<SocketBinding> socketBindingSupplier) {
        this.nodeIdentifier = nodeIdentifier;
        this.socketBindingSupplier = socketBindingSupplier;
    }

    public CoreEnvironmentBean getValue() throws IllegalStateException, IllegalArgumentException {
        CoreEnvironmentBean coreEnvironmentBean = arjPropertyManager.getCoreEnvironmentBean();
        return coreEnvironmentBean;
    }

    public void start(StartContext context) throws StartException {
        CoreEnvironmentBean coreEnvironmentBean = arjPropertyManager.getCoreEnvironmentBean();
        if (coreEnvironmentBean.getProcessImplementationClassName() == null) {
            UuidProcessId id = new UuidProcessId();
            coreEnvironmentBean.setProcessImplementation((Process)id);
        }
        try {
            coreEnvironmentBean.setNodeIdentifier(this.nodeIdentifier);
        }
        catch (CoreEnvironmentBeanException e) {
            throw new StartException(e.getCause());
        }
        SocketBinding binding = this.socketBindingSupplier.get();
        if (binding != null) {
            int port = binding.getPort();
            coreEnvironmentBean.setSocketProcessIdPort(port);
        }
    }

    public void stop(StopContext context) {
    }

    public int getSocketProcessIdMaxPorts() {
        return this.getValue().getSocketProcessIdMaxPorts();
    }

    public void setSocketProcessIdMaxPorts(int socketProcessIdMaxPorts) {
        this.getValue().setSocketProcessIdMaxPorts(socketProcessIdMaxPorts);
    }

    public void setProcessImplementationClassName(String clazz) {
        this.getValue().setProcessImplementationClassName(clazz);
    }

    public void setProcessImplementation(Process instance) {
        this.getValue().setProcessImplementation(instance);
    }
}

