/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.reactive.messaging.config.kafka.ssl.context;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.wildfly.microprofile.reactive.messaging.common.security.BaseReactiveMessagingSslConfigProcessor;
import org.wildfly.microprofile.reactive.messaging.config.kafka.ssl.context.WildFlyKafkaSSLEngineFactory;

class KafkaReactiveMessagingSslConfigProcessor
extends BaseReactiveMessagingSslConfigProcessor {
    static final String SSL_CONTEXT_PROPERTY_SUFFIX = "wildfly.elytron.ssl.context";
    private static final String SSL_ENGINE_FACTORY_CLASS = "ssl.engine.factory.class";
    private static final String CONNECTOR_NAME = "smallrye-kafka";

    KafkaReactiveMessagingSslConfigProcessor() {
        super(CONNECTOR_NAME);
    }

    protected BaseReactiveMessagingSslConfigProcessor.SecurityDeploymentContext createSecurityDeploymentContext() {
        return new KafkaSecurityDeploymentContext();
    }

    private class KafkaSecurityDeploymentContext
    implements BaseReactiveMessagingSslConfigProcessor.SecurityDeploymentContext {
        private final Map<String, String> addedProperties = new HashMap<String, String>();

        private KafkaSecurityDeploymentContext() {
        }

        public void setGlobalSslContext(String globalPropertyPrefix, String sslContext) {
            this.setSslContext(globalPropertyPrefix, sslContext);
        }

        public void setConnectorSslContext(String connectorPrefix, String sslContext) {
            this.setSslContext(connectorPrefix, sslContext);
        }

        private void setSslContext(String prefix, String sslContext) {
            if (sslContext == null) {
                return;
            }
            this.addedProperties.put(prefix + KafkaReactiveMessagingSslConfigProcessor.SSL_ENGINE_FACTORY_CLASS, WildFlyKafkaSSLEngineFactory.class.getName());
        }

        public Map<String, String> complete(DeploymentPhaseContext phaseContext) {
            return this.addedProperties;
        }
    }
}

