/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.metadata.fine;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.ee.cache.offset.Offset;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionAccessMetaDataEntryFunction;
import org.wildfly.clustering.web.cache.session.metadata.fine.SessionAccessMetaDataEntryOffsets;

public class SessionCreationMetaDataEntryFunctionMarshaller
implements ProtoStreamMarshaller<SessionAccessMetaDataEntryFunction> {
    private static final int SINCE_CREATION_OFFSET_INDEX = 1;
    private static final int LAST_ACCESS_OFFSET_INDEX = 2;

    public Class<? extends SessionAccessMetaDataEntryFunction> getJavaClass() {
        return SessionAccessMetaDataEntryFunction.class;
    }

    public SessionAccessMetaDataEntryFunction readFrom(ProtoStreamReader reader) throws IOException {
        final AtomicReference<Offset> sinceCreationOffset = new AtomicReference<Offset>(Offset.forDuration((Duration)Duration.ZERO));
        final AtomicReference<Offset> lastAccessOffset = new AtomicReference<Offset>(Offset.forDuration((Duration)Duration.ZERO));
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    sinceCreationOffset.setPlain((Offset)reader.readObject(sinceCreationOffset.getPlain().getClass()));
                    continue block4;
                }
                case 2: {
                    lastAccessOffset.setPlain((Offset)reader.readObject(lastAccessOffset.getPlain().getClass()));
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        return new SessionAccessMetaDataEntryFunction(new SessionAccessMetaDataEntryOffsets(){

            @Override
            public Offset<Duration> getSinceCreationOffset() {
                return (Offset)sinceCreationOffset.getPlain();
            }

            @Override
            public Offset<Duration> getLastAccessOffset() {
                return (Offset)lastAccessOffset.getPlain();
            }
        });
    }

    public void writeTo(ProtoStreamWriter writer, SessionAccessMetaDataEntryFunction function) throws IOException {
        Offset<Duration> lastAccessOffset;
        SessionAccessMetaDataEntryOffsets offsets = (SessionAccessMetaDataEntryOffsets)function.getOperand();
        Offset<Duration> sinceCreationOffset = offsets.getSinceCreationOffset();
        if (!sinceCreationOffset.isZero()) {
            writer.writeObject(1, sinceCreationOffset);
        }
        if (!(lastAccessOffset = offsets.getLastAccessOffset()).isZero()) {
            writer.writeObject(2, lastAccessOffset);
        }
    }
}

