/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementProvider;
import org.wildfly.extension.clustering.web.HotRodSessionManagementResourceDefinition;
import org.wildfly.extension.clustering.web.SessionManagementServiceConfigurator;
import org.wildfly.extension.clustering.web.session.hotrod.HotRodSessionManagementConfiguration;
import org.wildfly.extension.clustering.web.session.hotrod.HotRodSessionManagementProvider;

public class HotRodSessionManagementServiceConfigurator
extends SessionManagementServiceConfigurator<HotRodSessionManagementConfiguration<DeploymentUnit>>
implements HotRodSessionManagementConfiguration<DeploymentUnit> {
    private volatile String containerName;
    private volatile String configurationName;
    private volatile int expirationThreadPoolSize;

    HotRodSessionManagementServiceConfigurator(PathAddress address) {
        super(address);
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.containerName = HotRodSessionManagementResourceDefinition.Attribute.REMOTE_CACHE_CONTAINER.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.configurationName = HotRodSessionManagementResourceDefinition.Attribute.CACHE_CONFIGURATION.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        this.expirationThreadPoolSize = HotRodSessionManagementResourceDefinition.Attribute.EXPIRATION_THREAD_POOL_SIZE.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        return super.configure(context, model);
    }

    @Override
    public DistributableSessionManagementProvider<HotRodSessionManagementConfiguration<DeploymentUnit>> get() {
        return new HotRodSessionManagementProvider(this);
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    @Override
    public int getExpirationThreadPoolSize() {
        return this.expirationThreadPoolSize;
    }
}

