/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.repository.logging;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.as.repository.ExplodedContentException;
import org.jboss.as.repository.logging.DeploymentRepositoryLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class DeploymentRepositoryLogger_$logger
extends DelegatingBasicLogger
implements DeploymentRepositoryLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = DeploymentRepositoryLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public DeploymentRepositoryLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void contentAdded(String path) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.contentAdded$str(), (Object)path);
    }

    protected String contentAdded$str() {
        return "WFLYDR0001: Content added at location %s";
    }

    @Override
    public final void contentRemoved(String path) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.contentRemoved$str(), (Object)path);
    }

    protected String contentRemoved$str() {
        return "WFLYDR0002: Content removed from location %s";
    }

    @Override
    public final void cannotDeleteTempFile(Throwable cause, String path) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.cannotDeleteTempFile$str(), (Object)path);
    }

    protected String cannotDeleteTempFile$str() {
        return "WFLYDR0003: Cannot delete temp file %s, will be deleted on exit";
    }

    protected String cannotCreateDirectory$str() {
        return "WFLYDR0004: Cannot create directory %s";
    }

    @Override
    public final IllegalStateException cannotCreateDirectory(Throwable cause, String path) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotCreateDirectory$str(), path), cause);
        DeploymentRepositoryLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String cannotObtainSha1$str() {
        return "WFLYDR0005: Cannot obtain SHA-1 %s";
    }

    @Override
    public final IllegalStateException cannotObtainSha1(Throwable cause, String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotObtainSha1$str(), name), cause);
        DeploymentRepositoryLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String directoryNotWritable$str() {
        return "WFLYDR0006: Directory %s is not writable";
    }

    @Override
    public final IllegalStateException directoryNotWritable(String path) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.directoryNotWritable$str(), path));
        DeploymentRepositoryLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notADirectory$str() {
        return "WFLYDR0007: %s is not a directory";
    }

    @Override
    public final IllegalStateException notADirectory(String path) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.notADirectory$str(), path));
        DeploymentRepositoryLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void obsoleteContentCleaned(String contentIdentifier) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.obsoleteContentCleaned$str(), (Object)contentIdentifier);
    }

    protected String obsoleteContentCleaned$str() {
        return "WFLYDR0009: Content %s is obsolete and will be removed";
    }

    @Override
    public final void contentDeletionError(Throwable cause, String name) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.contentDeletionError$str(), (Object)name);
    }

    protected String contentDeletionError$str() {
        return "WFLYDR0010: Couldn't delete content %s";
    }

    @Override
    public final void localContentListError(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.localContentListError$str(), (Object)name);
    }

    protected String localContentListError$str() {
        return "WFLYDR0011: Couldn't list directory files for %s";
    }

    protected String hashingError$str() {
        return "WFLYDR0012: Cannot hash current deployment content %s";
    }

    @Override
    public final RuntimeException hashingError(Throwable cause, Path path) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.hashingError$str(), path), cause);
        DeploymentRepositoryLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String forbiddenPath$str() {
        return "WFLYDR0013: Access denied to the content at %s in the deployment";
    }

    @Override
    public final IllegalArgumentException forbiddenPath(String path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.forbiddenPath$str(), path));
        DeploymentRepositoryLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void couldNotDeleteDeployment(Exception ex, String path) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)ex, this.couldNotDeleteDeployment$str(), (Object)path);
    }

    protected String couldNotDeleteDeployment$str() {
        return "WFLYDR0014: Error deleting deployment %s";
    }

    protected String notAnArchive$str() {
        return "WFLYDR0015: %s is not an archive file";
    }

    @Override
    public final IllegalStateException notAnArchive(String path) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.notAnArchive$str(), path));
        DeploymentRepositoryLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String archiveNotFound$str() {
        return "WFLYDR0016: Achive file %s not found";
    }

    @Override
    public final ExplodedContentException archiveNotFound(String path) {
        ExplodedContentException result = new ExplodedContentException(String.format(this.getLoggingLocale(), this.archiveNotFound$str(), path));
        DeploymentRepositoryLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void contentExploded(String path) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.contentExploded$str(), (Object)path);
    }

    protected String contentExploded$str() {
        return "WFLYDR0017: Content exploded at location %s";
    }

    protected String errorExplodingContent$str() {
        return "WFLYDR0018: Error exploding content for %s";
    }

    @Override
    public final ExplodedContentException errorExplodingContent(Exception ex, String path) {
        ExplodedContentException result = new ExplodedContentException(String.format(this.getLoggingLocale(), this.errorExplodingContent$str(), path), ex);
        DeploymentRepositoryLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorLockingDeployment$str() {
        return "WFLYDR0019: Deployment is locked by another operation";
    }

    @Override
    public final ExplodedContentException errorLockingDeployment() {
        ExplodedContentException result = new ExplodedContentException(String.format(this.getLoggingLocale(), this.errorLockingDeployment$str(), new Object[0]));
        DeploymentRepositoryLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorAccessingDeployment$str() {
        return "WFLYDR0020: Error accessing deployment files";
    }

    @Override
    public final ExplodedContentException errorAccessingDeployment(Exception ex) {
        ExplodedContentException result = new ExplodedContentException(String.format(this.getLoggingLocale(), this.errorAccessingDeployment$str(), new Object[0]), ex);
        DeploymentRepositoryLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorUpdatingDeployment$str() {
        return "WFLYDR0021: Error updating content of exploded deployment";
    }

    @Override
    public final ExplodedContentException errorUpdatingDeployment(Exception ex) {
        ExplodedContentException result = new ExplodedContentException(String.format(this.getLoggingLocale(), this.errorUpdatingDeployment$str(), new Object[0]), ex);
        DeploymentRepositoryLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorCopyingDeployment$str() {
        return "WFLYDR0022: Error copying files of exploded deployment to %s";
    }

    @Override
    public final ExplodedContentException errorCopyingDeployment(Exception ex, String target) {
        ExplodedContentException result = new ExplodedContentException(String.format(this.getLoggingLocale(), this.errorCopyingDeployment$str(), target), ex);
        DeploymentRepositoryLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void cannotDeleteFile(Exception ex, Path path) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)ex, this.cannotDeleteFile$str(), (Object)path);
    }

    protected String cannotDeleteFile$str() {
        return "WFLYDR0023: Error deleting file %s";
    }

    @Override
    public final void cannotCopyFile(Exception ex, Path path) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)ex, this.cannotCopyFile$str(), (Object)path);
    }

    protected String cannotCopyFile$str() {
        return "WFLYDR0024: Error copying file %s";
    }
}

