/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import org.hibernate.Incubating;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ScrollMode;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.FunctionContributor;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.dialect.ColumnAliasExtractor;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupportImpl;
import org.hibernate.dialect.LobMergeStrategy;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.AggregateSupportImpl;
import org.hibernate.dialect.function.CastFunction;
import org.hibernate.dialect.function.CastStrEmulation;
import org.hibernate.dialect.function.CoalesceIfnullEmulation;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.CurrentFunction;
import org.hibernate.dialect.function.ExtractFunction;
import org.hibernate.dialect.function.InsertSubstringOverlayEmulation;
import org.hibernate.dialect.function.LocatePositionEmulation;
import org.hibernate.dialect.function.LpadRpadPadEmulation;
import org.hibernate.dialect.function.SqlFunction;
import org.hibernate.dialect.function.TimestampaddFunction;
import org.hibernate.dialect.function.TimestampdiffFunction;
import org.hibernate.dialect.function.TrimFunction;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupportImpl;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.PessimisticReadSelectLockingStrategy;
import org.hibernate.dialect.lock.PessimisticWriteSelectLockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.NoSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.StandardTemporaryTableExporter;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableExporter;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.unique.AlterTableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.internal.DefaultSchemaNameResolver;
import org.hibernate.engine.jdbc.env.spi.AnsiSqlKeywords;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.jdbc.env.spi.SchemaNameResolver;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.exception.spi.ConversionContext;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.MathHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.io.StreamCopier;
import org.hibernate.loader.ast.spi.MultiKeyLoadSizingStrategy;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UserDefinedType;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.procedure.internal.StandardCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.PersistentTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.PersistentTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StringBuilderSqlAppender;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.sql.model.jdbc.OptionalTableUpdateOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorLegacyImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.StandardAuxiliaryDatabaseObjectExporter;
import org.hibernate.tool.schema.internal.StandardForeignKeyExporter;
import org.hibernate.tool.schema.internal.StandardIndexExporter;
import org.hibernate.tool.schema.internal.StandardSequenceExporter;
import org.hibernate.tool.schema.internal.StandardTableCleaner;
import org.hibernate.tool.schema.internal.StandardTableExporter;
import org.hibernate.tool.schema.internal.StandardTableMigrator;
import org.hibernate.tool.schema.internal.StandardUniqueKeyExporter;
import org.hibernate.tool.schema.internal.StandardUserDefinedTypeExporter;
import org.hibernate.tool.schema.internal.TableMigrator;
import org.hibernate.tool.schema.spi.Cleaner;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.SqlTypes;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.internal.EnumHelper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcTypeConstructor;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeConstructor;
import org.hibernate.type.descriptor.jdbc.LongNVarcharJdbcType;
import org.hibernate.type.descriptor.jdbc.NCharJdbcType;
import org.hibernate.type.descriptor.jdbc.NClobJdbcType;
import org.hibernate.type.descriptor.jdbc.NVarcharJdbcType;
import org.hibernate.type.descriptor.jdbc.TimeUtcAsJdbcTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.TimeUtcAsOffsetTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.TimestampUtcAsJdbcTimestampJdbcType;
import org.hibernate.type.descriptor.jdbc.TimestampUtcAsOffsetDateTimeJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.ArrayDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public abstract class Dialect
implements ConversionContext,
TypeContributor,
FunctionContributor {
    public static final String QUOTE = "`\"[";
    public static final String CLOSED_QUOTE = "`\"]";
    private static final Pattern ESCAPE_CLOSING_COMMENT_PATTERN = Pattern.compile("\\*/");
    private static final Pattern ESCAPE_OPENING_COMMENT_PATTERN = Pattern.compile("/\\*");
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)Dialect.class.getName());
    protected static final double LOG_BASE2OF10 = Math.log(10.0) / Math.log(2.0);
    private final Properties properties = new Properties();
    private final Set<String> sqlKeywords = new HashSet<String>();
    private final SizeStrategy sizeStrategy = new SizeStrategyImpl();
    private final DatabaseVersion version;
    protected static final LobMergeStrategy LEGACY_LOB_MERGE_STRATEGY = new LobMergeStrategy(){

        @Override
        public Blob mergeBlob(Blob original, Blob target, SharedSessionContractImplementor session) {
            return target;
        }

        @Override
        public Clob mergeClob(Clob original, Clob target, SharedSessionContractImplementor session) {
            return target;
        }

        @Override
        public NClob mergeNClob(NClob original, NClob target, SharedSessionContractImplementor session) {
            return target;
        }
    };
    protected static final LobMergeStrategy STREAM_XFER_LOB_MERGE_STRATEGY = new LobMergeStrategy(){

        @Override
        public Blob mergeBlob(Blob original, Blob target, SharedSessionContractImplementor session) {
            if (original != target) {
                try {
                    OutputStream connectedStream = target.setBinaryStream(1L);
                    InputStream detachedStream = original.getBinaryStream();
                    StreamCopier.copy(detachedStream, connectedStream);
                    return target;
                }
                catch (SQLException e) {
                    throw session.getFactory().getJdbcServices().getSqlExceptionHelper().convert(e, "unable to merge BLOB data");
                }
            }
            return NEW_LOCATOR_LOB_MERGE_STRATEGY.mergeBlob(original, target, session);
        }

        @Override
        public Clob mergeClob(Clob original, Clob target, SharedSessionContractImplementor session) {
            if (original != target) {
                try {
                    OutputStream connectedStream = target.setAsciiStream(1L);
                    InputStream detachedStream = original.getAsciiStream();
                    StreamCopier.copy(detachedStream, connectedStream);
                    return target;
                }
                catch (SQLException e) {
                    throw session.getFactory().getJdbcServices().getSqlExceptionHelper().convert(e, "unable to merge CLOB data");
                }
            }
            return NEW_LOCATOR_LOB_MERGE_STRATEGY.mergeClob(original, target, session);
        }

        @Override
        public NClob mergeNClob(NClob original, NClob target, SharedSessionContractImplementor session) {
            if (original != target) {
                try {
                    OutputStream connectedStream = target.setAsciiStream(1L);
                    InputStream detachedStream = original.getAsciiStream();
                    StreamCopier.copy(detachedStream, connectedStream);
                    return target;
                }
                catch (SQLException e) {
                    throw session.getFactory().getJdbcServices().getSqlExceptionHelper().convert(e, "unable to merge NCLOB data");
                }
            }
            return NEW_LOCATOR_LOB_MERGE_STRATEGY.mergeNClob(original, target, session);
        }
    };
    protected static final LobMergeStrategy NEW_LOCATOR_LOB_MERGE_STRATEGY = new LobMergeStrategy(){

        @Override
        public Blob mergeBlob(Blob original, Blob target, SharedSessionContractImplementor session) {
            if (original == null && target == null) {
                return null;
            }
            JdbcServices jdbcServices = session.getFactory().getFastSessionServices().jdbcServices;
            try {
                LobCreator lobCreator = jdbcServices.getLobCreator(session);
                return original == null ? lobCreator.createBlob(ArrayHelper.EMPTY_BYTE_ARRAY) : lobCreator.createBlob(original.getBinaryStream(), original.length());
            }
            catch (SQLException e) {
                throw jdbcServices.getSqlExceptionHelper().convert(e, "unable to merge BLOB data");
            }
        }

        @Override
        public Clob mergeClob(Clob original, Clob target, SharedSessionContractImplementor session) {
            if (original == null && target == null) {
                return null;
            }
            JdbcServices jdbcServices = session.getFactory().getFastSessionServices().jdbcServices;
            try {
                LobCreator lobCreator = jdbcServices.getLobCreator(session);
                return original == null ? lobCreator.createClob("") : lobCreator.createClob(original.getCharacterStream(), original.length());
            }
            catch (SQLException e) {
                throw jdbcServices.getSqlExceptionHelper().convert(e, "unable to merge CLOB data");
            }
        }

        @Override
        public NClob mergeNClob(NClob original, NClob target, SharedSessionContractImplementor session) {
            if (original == null && target == null) {
                return null;
            }
            JdbcServices jdbcServices = session.getFactory().getFastSessionServices().jdbcServices;
            try {
                LobCreator lobCreator = jdbcServices.getLobCreator(session);
                return original == null ? lobCreator.createNClob("") : lobCreator.createNClob(original.getCharacterStream(), original.length());
            }
            catch (SQLException e) {
                throw jdbcServices.getSqlExceptionHelper().convert(e, "unable to merge NCLOB data");
            }
        }
    };
    private static final ViolatedConstraintNameExtractor EXTRACTOR = sqle -> null;
    private final StandardTableExporter tableExporter = new StandardTableExporter(this);
    private final StandardUserDefinedTypeExporter userDefinedTypeExporter = new StandardUserDefinedTypeExporter(this);
    private final StandardSequenceExporter sequenceExporter = new StandardSequenceExporter(this);
    private final StandardIndexExporter indexExporter = new StandardIndexExporter(this);
    private final StandardForeignKeyExporter foreignKeyExporter = new StandardForeignKeyExporter(this);
    private final StandardUniqueKeyExporter uniqueKeyExporter = new StandardUniqueKeyExporter(this);
    private final StandardAuxiliaryDatabaseObjectExporter auxiliaryObjectExporter = new StandardAuxiliaryDatabaseObjectExporter(this);
    private final StandardTemporaryTableExporter temporaryTableExporter = new StandardTemporaryTableExporter(this);
    private final StandardTableMigrator tableMigrator = new StandardTableMigrator(this);
    private final StandardTableCleaner tableCleaner = new StandardTableCleaner(this);
    protected final MultiKeyLoadSizingStrategy STANDARD_MULTI_KEY_LOAD_SIZING_STRATEGY = (numberOfColumns, numberOfKeys, pad) -> {
        numberOfKeys = pad ? MathHelper.ceilingPowerOfTwo(numberOfKeys) : numberOfKeys;
        long parameterCount = (long)numberOfColumns * (long)numberOfKeys;
        int limit = this.getParameterCountLimit();
        if (limit > 0 && parameterCount >= (long)limit) {
            return limit / numberOfColumns;
        }
        return numberOfKeys;
    };

    @Deprecated(since="6.0")
    protected Dialect() {
        this((DatabaseVersion)null);
    }

    protected Dialect(DatabaseVersion version) {
        this.version = version;
        this.checkVersion();
        this.registerDefaultKeywords();
        this.initDefaultProperties();
    }

    protected Dialect(DialectResolutionInfo info) {
        this.version = info.makeCopy();
        this.checkVersion();
        this.registerDefaultKeywords();
        this.registerKeywords(info);
        this.initDefaultProperties();
    }

    protected void checkVersion() {
        DatabaseVersion version = this.getVersion();
        DatabaseVersion minimumVersion = this.getMinimumSupportedVersion();
        if (version != null && version.isBefore(minimumVersion.getMajor(), minimumVersion.getMinor(), minimumVersion.getMicro())) {
            LOG.unsupportedDatabaseVersion(this.getClass().getName(), version.getMajor() + "." + version.getMinor() + "." + version.getMicro(), minimumVersion.getMajor() + "." + minimumVersion.getMinor() + "." + minimumVersion.getMicro());
        }
    }

    protected void initDefaultProperties() {
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", Integer.toString(this.getDefaultStatementBatchSize()));
        this.getDefaultProperties().setProperty("hibernate.jdbc.lob.non_contextual_creation", Boolean.toString(this.getDefaultNonContextualLobCreation()));
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_get_generated_keys", Boolean.toString(this.getDefaultUseGetGeneratedKeys()));
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(16));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(-6));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(5));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(4));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(-5));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(6));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(7));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(8));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(2));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(3));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(91));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(92));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(2013));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(3007));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(93));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(2014));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(3003));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(1));
        ddlTypeRegistry.addDescriptor(this.sqlTypeBuilder(12, 4001, 12).withTypeCapacity(this.getMaxVarcharLength(), this.columnType(12)).build());
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(2005));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(-15));
        ddlTypeRegistry.addDescriptor(this.sqlTypeBuilder(-9, 4002, -9).withTypeCapacity(this.getMaxNVarcharLength(), this.columnType(-9)).build());
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(2011));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(-2));
        ddlTypeRegistry.addDescriptor(this.sqlTypeBuilder(-3, 4003, -3).withTypeCapacity(this.getMaxVarbinaryLength(), this.columnType(-3)).build());
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(2004));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(4001));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(4002));
        ddlTypeRegistry.addDescriptor(this.simpleSqlType(4003));
        if (this.supportsStandardArrays()) {
            ddlTypeRegistry.addDescriptor(new ArrayDdlTypeImpl(this, false));
        }
        if (this.rowId(null) != null) {
            ddlTypeRegistry.addDescriptor(this.simpleSqlType(-8));
        }
    }

    protected boolean isLob(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 2004: 
            case 2005: 
            case 2011: 
            case 4001: 
            case 4002: 
            case 4003: {
                return true;
            }
        }
        return false;
    }

    private DdlTypeImpl simpleSqlType(int sqlTypeCode) {
        return new DdlTypeImpl(sqlTypeCode, this.isLob(sqlTypeCode), this.columnType(sqlTypeCode), this.castType(sqlTypeCode), this);
    }

    private CapacityDependentDdlType.Builder sqlTypeBuilder(int sqlTypeCode, int biggestSqlTypeCode, int castTypeCode) {
        return CapacityDependentDdlType.builder(sqlTypeCode, this.isLob(sqlTypeCode) ? CapacityDependentDdlType.LobKind.ALL_LOB : (this.isLob(biggestSqlTypeCode) ? CapacityDependentDdlType.LobKind.BIGGEST_LOB : CapacityDependentDdlType.LobKind.NONE), this.columnType(biggestSqlTypeCode), this.castType(castTypeCode), this);
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -8: {
                return "rowid";
            }
            case 16: {
                return "boolean";
            }
            case -6: {
                return "tinyint";
            }
            case 5: {
                return "smallint";
            }
            case 4: {
                return "integer";
            }
            case -5: {
                return "bigint";
            }
            case 6: {
                return "float($p)";
            }
            case 7: {
                return "real";
            }
            case 8: {
                return "double precision";
            }
            case 2: {
                return "numeric($p,$s)";
            }
            case 3: {
                return "decimal($p,$s)";
            }
            case 91: {
                return "date";
            }
            case 92: {
                return "time($p)";
            }
            case 2013: {
                return "time($p) with time zone";
            }
            case 93: {
                return "timestamp($p)";
            }
            case 2014: {
                return "timestamp($p) with time zone";
            }
            case 3007: {
                return this.getTimeZoneSupport() == TimeZoneSupport.NATIVE ? this.columnType(2013) : this.columnType(92);
            }
            case 3003: {
                return this.getTimeZoneSupport() == TimeZoneSupport.NATIVE ? this.columnType(2014) : this.columnType(93);
            }
            case 1: {
                return "char($l)";
            }
            case 12: {
                return "varchar($l)";
            }
            case 2005: {
                return "clob";
            }
            case -15: {
                return "nchar($l)";
            }
            case -9: {
                return "nvarchar($l)";
            }
            case 2011: {
                return "nclob";
            }
            case -2: {
                return "binary($l)";
            }
            case -3: {
                return "varbinary($l)";
            }
            case 2004: {
                return "blob";
            }
            case 4001: {
                return this.columnType(2005);
            }
            case 4002: {
                return this.columnType(2011);
            }
            case 4003: {
                return this.columnType(2004);
            }
        }
        throw new IllegalArgumentException("unknown type: " + sqlTypeCode);
    }

    protected String castType(int sqlTypeCode) {
        return this.columnType(sqlTypeCode);
    }

    protected void registerDefaultKeywords() {
        AnsiSqlKeywords keywords = new AnsiSqlKeywords();
        this.sqlKeywords.addAll(keywords.sql2003());
    }

    protected void registerKeywords(DialectResolutionInfo info) {
        for (String keyword : StringHelper.parseCommaSeparatedString(info.getSQLKeywords())) {
            this.registerKeyword(keyword);
        }
    }

    public DatabaseVersion getVersion() {
        return this.version;
    }

    protected DatabaseVersion getMinimumSupportedVersion() {
        return SimpleDatabaseVersion.ZERO_VERSION;
    }

    protected Integer resolveSqlTypeCode(String columnTypeName, TypeConfiguration typeConfiguration) {
        int parenthesisIndex = columnTypeName.lastIndexOf(40);
        String baseTypeName = parenthesisIndex == -1 ? columnTypeName : columnTypeName.substring(0, parenthesisIndex).trim();
        return this.resolveSqlTypeCode(columnTypeName, baseTypeName, typeConfiguration);
    }

    protected Integer resolveSqlTypeCode(String typeName, String baseTypeName, TypeConfiguration typeConfiguration) {
        return typeConfiguration.getDdlTypeRegistry().getSqlTypeCode(baseTypeName);
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        String componentTypeName;
        Integer sqlTypeCode;
        int arraySuffixIndex;
        JdbcTypeConstructor jdbcTypeConstructor;
        if (jdbcTypeCode == 2003 && (jdbcTypeConstructor = jdbcTypeRegistry.getConstructor(jdbcTypeCode)) != null && (arraySuffixIndex = columnTypeName.toLowerCase(Locale.ROOT).indexOf(" array")) != -1 && (sqlTypeCode = this.resolveSqlTypeCode(componentTypeName = columnTypeName.substring(0, arraySuffixIndex), jdbcTypeRegistry.getTypeConfiguration())) != null) {
            return jdbcTypeConstructor.resolveType(jdbcTypeRegistry.getTypeConfiguration(), this, jdbcTypeRegistry.getDescriptor(sqlTypeCode), ColumnTypeInformation.EMPTY);
        }
        return jdbcTypeRegistry.getDescriptor(jdbcTypeCode);
    }

    public int resolveSqlTypeLength(String columnTypeName, int jdbcTypeCode, int precision, int scale, int displaySize) {
        if (jdbcTypeCode == 1 && precision <= 4) {
            return displaySize;
        }
        return precision;
    }

    public String getEnumTypeDeclaration(String name, String[] values) {
        return null;
    }

    public String getEnumTypeDeclaration(Class<? extends Enum<?>> enumType) {
        return this.getEnumTypeDeclaration(enumType.getSimpleName(), EnumHelper.getEnumeratedValues(enumType));
    }

    public String[] getCreateEnumTypeCommand(String name, String[] values) {
        return ArrayHelper.EMPTY_STRING_ARRAY;
    }

    public String[] getCreateEnumTypeCommand(Class<? extends Enum<?>> enumType) {
        return this.getCreateEnumTypeCommand(enumType.getSimpleName(), EnumHelper.getEnumeratedValues(enumType));
    }

    public String[] getDropEnumTypeCommand(String name) {
        return ArrayHelper.EMPTY_STRING_ARRAY;
    }

    public String[] getDropEnumTypeCommand(Class<? extends Enum<?>> enumType) {
        return this.getDropEnumTypeCommand(enumType.getSimpleName());
    }

    public String getCheckCondition(String columnName, String[] values) {
        StringBuilder check = new StringBuilder();
        check.append(columnName).append(" in (");
        String separator = "";
        for (String value : values) {
            check.append(separator).append('\'').append(value).append('\'');
            separator = ",";
        }
        return check.append(')').toString();
    }

    public String getCheckCondition(String columnName, Class<? extends Enum<?>> enumType) {
        return this.getCheckCondition(columnName, EnumHelper.getEnumeratedValues(enumType));
    }

    public String getCheckCondition(String columnName, long min, long max) {
        return columnName + " between " + min + " and " + max;
    }

    public String getCheckCondition(String columnName, long[] values) {
        StringBuilder check = new StringBuilder();
        check.append(columnName).append(" in (");
        String separator = "";
        for (long value : values) {
            check.append(separator).append(value);
            separator = ",";
        }
        return check.append(')').toString();
    }

    @Override
    public void contributeFunctions(FunctionContributions functionContributions) {
        this.initializeFunctionRegistry(functionContributions);
    }

    @Override
    public int ordinal() {
        return 0;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        TypeConfiguration typeConfiguration = functionContributions.getTypeConfiguration();
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        BasicType<Date> timestampType = basicTypeRegistry.resolve(StandardBasicTypes.TIMESTAMP);
        BasicType<Date> dateType = basicTypeRegistry.resolve(StandardBasicTypes.DATE);
        BasicType<Date> timeType = basicTypeRegistry.resolve(StandardBasicTypes.TIME);
        BasicType<Instant> instantType = basicTypeRegistry.resolve(StandardBasicTypes.INSTANT);
        BasicType<OffsetDateTime> offsetDateTimeType = basicTypeRegistry.resolve(StandardBasicTypes.OFFSET_DATE_TIME);
        BasicType<LocalDateTime> localDateTimeType = basicTypeRegistry.resolve(StandardBasicTypes.LOCAL_DATE_TIME);
        BasicType<LocalTime> localTimeType = basicTypeRegistry.resolve(StandardBasicTypes.LOCAL_TIME);
        BasicType<LocalDate> localDateType = basicTypeRegistry.resolve(StandardBasicTypes.LOCAL_DATE);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.aggregates(this, SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.everyAny_sumCase(this.supportsPredicateAsExpression());
        functionFactory.math();
        functionFactory.round();
        functionFactory.trigonometry();
        functionFactory.sinh_exp();
        functionFactory.cosh_exp();
        functionFactory.tanh_exp();
        functionFactory.pi_acos();
        functionFactory.log_ln();
        functionFactory.coalesce();
        functionFactory.nullif();
        functionFactory.leftRight();
        functionFactory.replace();
        functionFactory.concat();
        functionFactory.lowerUpper();
        functionFactory.substring();
        functionFactory.locate();
        functionFactory.length_characterLength();
        functionContributions.getFunctionRegistry().register("position", new LocatePositionEmulation(typeConfiguration));
        functionContributions.getFunctionRegistry().register("overlay", new InsertSubstringOverlayEmulation(typeConfiguration, false));
        functionContributions.getFunctionRegistry().register("trim", new TrimFunction(this, typeConfiguration));
        functionContributions.getFunctionRegistry().register("cast", new CastFunction(this, functionContributions.getTypeConfiguration().getCurrentBaseSqlTypeIndicators().getPreferredSqlTypeCodeForBoolean()));
        functionFactory.collate();
        functionContributions.getFunctionRegistry().register("extract", new ExtractFunction(this, typeConfiguration));
        functionFactory.leastGreatest();
        functionContributions.getFunctionRegistry().register("ifnull", new CoalesceIfnullEmulation());
        functionFactory.pad();
        functionContributions.getFunctionRegistry().register("pad", new LpadRpadPadEmulation(typeConfiguration));
        functionContributions.getFunctionRegistry().register("str", new CastStrEmulation(typeConfiguration));
        functionFactory.format_toChar();
        functionContributions.getFunctionRegistry().register("timestampadd", new TimestampaddFunction(this, typeConfiguration));
        functionContributions.getFunctionRegistry().register("timestampdiff", new TimestampdiffFunction(this, typeConfiguration));
        functionContributions.getFunctionRegistry().registerAlternateKey("dateadd", "timestampadd");
        functionContributions.getFunctionRegistry().registerAlternateKey("datediff", "timestampdiff");
        functionContributions.getFunctionRegistry().register("current_date", new CurrentFunction("current_date", this.currentDate(), dateType));
        functionContributions.getFunctionRegistry().register("current_time", new CurrentFunction("current_time", this.currentTime(), timeType));
        functionContributions.getFunctionRegistry().register("current_timestamp", new CurrentFunction("current_timestamp", this.currentTimestamp(), timestampType));
        functionContributions.getFunctionRegistry().registerAlternateKey("current date", "current_date");
        functionContributions.getFunctionRegistry().registerAlternateKey("current time", "current_time");
        functionContributions.getFunctionRegistry().registerAlternateKey("current timestamp", "current_timestamp");
        functionContributions.getFunctionRegistry().register("local_date", new CurrentFunction("local_date", this.currentDate(), localDateType));
        functionContributions.getFunctionRegistry().register("local_time", new CurrentFunction("local_time", this.currentLocalTime(), localTimeType));
        functionContributions.getFunctionRegistry().register("local_datetime", new CurrentFunction("local_datetime", this.currentLocalTimestamp(), localDateTimeType));
        functionContributions.getFunctionRegistry().register("offset_datetime", new CurrentFunction("offset_datetime", this.currentTimestampWithTimeZone(), offsetDateTimeType));
        functionContributions.getFunctionRegistry().registerAlternateKey("local date", "local_date");
        functionContributions.getFunctionRegistry().registerAlternateKey("local time", "local_time");
        functionContributions.getFunctionRegistry().registerAlternateKey("local datetime", "local_datetime");
        functionContributions.getFunctionRegistry().registerAlternateKey("offset datetime", "offset_datetime");
        functionContributions.getFunctionRegistry().register("instant", new CurrentFunction("instant", this.currentTimestampWithTimeZone(), instantType));
        functionContributions.getFunctionRegistry().registerAlternateKey("current_instant", "instant");
        functionContributions.getFunctionRegistry().register("sql", new SqlFunction());
    }

    public String currentDate() {
        return "current_date";
    }

    public String currentTime() {
        return "current_time";
    }

    public String currentTimestamp() {
        return "current_timestamp";
    }

    public String currentLocalTime() {
        return this.currentTime();
    }

    public String currentLocalTimestamp() {
        return this.currentTimestamp();
    }

    public String currentTimestampWithTimeZone() {
        return this.currentTimestamp();
    }

    public String extractPattern(TemporalUnit unit) {
        return "extract(?1 from ?2)";
    }

    public String castPattern(CastType from, CastType to) {
        switch (to) {
            case STRING: {
                switch (from) {
                    case INTEGER_BOOLEAN: {
                        return "case ?1 when 1 then 'true' when 0 then 'false' else null end";
                    }
                    case YN_BOOLEAN: {
                        return "case ?1 when 'Y' then 'true' when 'N' then 'false' else null end";
                    }
                    case TF_BOOLEAN: {
                        return "case ?1 when 'T' then 'true' when 'F' then 'false' else null end";
                    }
                }
                break;
            }
            case INTEGER: 
            case LONG: {
                switch (from) {
                    case YN_BOOLEAN: {
                        return "case ?1 when 'Y' then 1 when 'N' then 0 else null end";
                    }
                    case TF_BOOLEAN: {
                        return "case ?1 when 'T' then 1 when 'F' then 0 else null end";
                    }
                    case BOOLEAN: {
                        return "case ?1 when true then 1 when false then 0 else null end";
                    }
                }
                break;
            }
            case INTEGER_BOOLEAN: {
                switch (from) {
                    case STRING: {
                        return "case ?1 when 'T' then 1 when 'Y' then 1 when 'F' then 0 when 'N' then 0 else null end";
                    }
                    case INTEGER: 
                    case LONG: {
                        return "abs(sign(?1))";
                    }
                    case YN_BOOLEAN: {
                        return "case ?1 when 'Y' then 1 when 'N' then 0 else null end";
                    }
                    case TF_BOOLEAN: {
                        return "case ?1 when 'T' then 1 when 'F' then 0 else null end";
                    }
                    case BOOLEAN: {
                        return "case ?1 when true then 1 when false then 0 else null end";
                    }
                }
                break;
            }
            case YN_BOOLEAN: {
                switch (from) {
                    case STRING: {
                        return "case ?1 when 'T' then 'Y' when 'Y' then 'Y' when 'F' then 'N' when 'N' then 'N' else null end";
                    }
                    case INTEGER_BOOLEAN: {
                        return "case ?1 when 1 then 'Y' when 0 then 'N' else null end";
                    }
                    case INTEGER: 
                    case LONG: {
                        return "case abs(sign(?1)) when 1 then 'Y' when 0 then 'N' else null end";
                    }
                    case TF_BOOLEAN: {
                        return "case ?1 when 'T' then 'Y' when 'F' then 'N' else null end";
                    }
                    case BOOLEAN: {
                        return "case ?1 when true then 'Y' when false then 'N' else null end";
                    }
                }
                break;
            }
            case TF_BOOLEAN: {
                switch (from) {
                    case STRING: {
                        return "case ?1 when 'T' then 'T' when 'Y' then 'T' when 'F' then 'F' when 'N' then 'F' else null end";
                    }
                    case INTEGER_BOOLEAN: {
                        return "case ?1 when 1 then 'T' when 0 then 'F' else null end";
                    }
                    case INTEGER: 
                    case LONG: {
                        return "case abs(sign(?1)) when 1 then 'T' when 0 then 'F' else null end";
                    }
                    case YN_BOOLEAN: {
                        return "case ?1 when 'Y' then 'T' when 'N' then 'F' else null end";
                    }
                    case BOOLEAN: {
                        return "case ?1 when true then 'T' when false then 'F' else null end";
                    }
                }
                break;
            }
            case BOOLEAN: {
                switch (from) {
                    case STRING: {
                        return "case ?1 when 'T' then true when 'Y' then true when 'F' then false when 'N' then false else null end";
                    }
                    case INTEGER_BOOLEAN: 
                    case INTEGER: 
                    case LONG: {
                        return "(?1<>0)";
                    }
                    case YN_BOOLEAN: {
                        return "(?1<>'N')";
                    }
                    case TF_BOOLEAN: {
                        return "(?1<>'F')";
                    }
                }
            }
        }
        return "cast(?1 as ?2)";
    }

    @Deprecated(forRemoval=true)
    public String trimPattern(TrimSpec specification, char character) {
        return this.trimPattern(specification, character == ' ');
    }

    public String trimPattern(TrimSpec specification, boolean isWhitespace) {
        return "trim(" + specification + (isWhitespace ? "" : " ?2") + " from ?1)";
    }

    public boolean supportsFractionalTimestampArithmetic() {
        return true;
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        throw new UnsupportedOperationException("`" + this.getClass().getName() + "` does not yet support #timestampdiffPattern");
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        throw new UnsupportedOperationException("`" + this.getClass().getName() + "` does not yet support #timestampaddPattern");
    }

    public boolean equivalentTypes(int typeCode1, int typeCode2) {
        return typeCode1 == typeCode2 || SqlTypes.isNumericOrDecimal(typeCode1) && SqlTypes.isNumericOrDecimal(typeCode2) || SqlTypes.isFloatOrRealOrDouble(typeCode1) && SqlTypes.isFloatOrRealOrDouble(typeCode2) || SqlTypes.isVarcharType(typeCode1) && SqlTypes.isVarcharType(typeCode2) || SqlTypes.isVarbinaryType(typeCode1) && SqlTypes.isVarbinaryType(typeCode2) || this.sameColumnType(typeCode1, typeCode2);
    }

    private boolean sameColumnType(int typeCode1, int typeCode2) {
        try {
            return Objects.equals(this.columnType(typeCode1), this.columnType(typeCode2));
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public Properties getDefaultProperties() {
        return this.properties;
    }

    public int getDefaultStatementBatchSize() {
        return 1;
    }

    public boolean getDefaultNonContextualLobCreation() {
        return false;
    }

    public boolean getDefaultUseGetGeneratedKeys() {
        return true;
    }

    public String toString() {
        return this.getClass().getName() + ", version: " + this.getVersion();
    }

    @Override
    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        this.contributeTypes(typeContributions, serviceRegistry);
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        this.registerColumnTypes(typeContributions, serviceRegistry);
        NationalizationSupport nationalizationSupport = this.getNationalizationSupport();
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        if (nationalizationSupport == NationalizationSupport.EXPLICIT) {
            jdbcTypeRegistry.addDescriptor(NCharJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(NVarcharJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(LongNVarcharJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(NClobJdbcType.DEFAULT);
        }
        if (this.useInputStreamToInsertBlob()) {
            jdbcTypeRegistry.addDescriptor(2005, ClobJdbcType.STREAM_BINDING);
        }
        if (this.getTimeZoneSupport() == TimeZoneSupport.NATIVE) {
            jdbcTypeRegistry.addDescriptor(TimestampUtcAsOffsetDateTimeJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(TimeUtcAsOffsetTimeJdbcType.INSTANCE);
        } else {
            jdbcTypeRegistry.addDescriptor(TimestampUtcAsJdbcTimestampJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(TimeUtcAsJdbcTimeJdbcType.INSTANCE);
        }
        if (this.supportsStandardArrays()) {
            jdbcTypeRegistry.addTypeConstructor(ArrayJdbcTypeConstructor.INSTANCE);
        }
        if (this.supportsMaterializedLobAccess()) {
            jdbcTypeRegistry.addDescriptor(3004, BlobJdbcType.MATERIALIZED);
            jdbcTypeRegistry.addDescriptor(3005, ClobJdbcType.MATERIALIZED);
            jdbcTypeRegistry.addDescriptor(3006, NClobJdbcType.MATERIALIZED);
        }
    }

    public LobMergeStrategy getLobMergeStrategy() {
        return NEW_LOCATOR_LOB_MERGE_STRATEGY;
    }

    public String getNativeIdentifierGeneratorStrategy() {
        return this.getIdentityColumnSupport().supportsIdentityColumns() ? "identity" : "sequence";
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return IdentityColumnSupportImpl.INSTANCE;
    }

    public SequenceSupport getSequenceSupport() {
        return NoSequenceSupport.INSTANCE;
    }

    public String getQuerySequencesString() {
        return null;
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.getQuerySequencesString() == null ? SequenceInformationExtractorNoOpImpl.INSTANCE : SequenceInformationExtractorLegacyImpl.INSTANCE;
    }

    public String getSelectGUIDString() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support GUIDs");
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public boolean supportsTemporaryTablePrimaryKey() {
        return true;
    }

    public LimitHandler getLimitHandler() {
        throw new UnsupportedOperationException("this dialect does not support query pagination");
    }

    public boolean supportsLockTimeouts() {
        return true;
    }

    @Deprecated(since="6", forRemoval=true)
    public boolean isLockTimeoutParameterized() {
        return false;
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        switch (lockMode) {
            case PESSIMISTIC_FORCE_INCREMENT: {
                return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_WRITE: {
                return new PessimisticWriteSelectLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_READ: {
                return new PessimisticReadSelectLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC: {
                return new OptimisticLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC_FORCE_INCREMENT: {
                return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
        }
        return new SelectLockingStrategy(lockable, lockMode);
    }

    public String getForUpdateString(LockOptions lockOptions) {
        return this.getForUpdateString(lockOptions.getLockMode(), lockOptions.getTimeOut());
    }

    private String getForUpdateString(LockMode lockMode, int timeout) {
        switch (lockMode) {
            case PESSIMISTIC_READ: {
                return this.getReadLockString(timeout);
            }
            case PESSIMISTIC_WRITE: {
                return this.getWriteLockString(timeout);
            }
            case PESSIMISTIC_FORCE_INCREMENT: 
            case UPGRADE_NOWAIT: {
                return this.getForUpdateNowaitString();
            }
            case UPGRADE_SKIPLOCKED: {
                return this.getForUpdateSkipLockedString();
            }
        }
        return "";
    }

    public String getForUpdateString(LockMode lockMode) {
        return this.getForUpdateString(lockMode, -1);
    }

    public String getForUpdateString() {
        return " for update";
    }

    public String getWriteLockString(int timeout) {
        return this.getForUpdateString();
    }

    public String getWriteLockString(String aliases, int timeout) {
        return this.getWriteLockString(timeout);
    }

    public String getReadLockString(int timeout) {
        return this.getForUpdateString();
    }

    public String getReadLockString(String aliases, int timeout) {
        return this.getReadLockString(timeout);
    }

    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.NONE;
    }

    public RowLockStrategy getReadRowLockStrategy() {
        return this.getWriteRowLockStrategy();
    }

    public boolean supportsOuterJoinForUpdate() {
        return true;
    }

    public String getForUpdateString(String aliases) {
        return this.getForUpdateString();
    }

    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        LockMode lockMode = lockOptions.getLockMode();
        for (Map.Entry<String, LockMode> entry : lockOptions.getAliasSpecificLocks()) {
            LockMode lm = entry.getValue();
            if (!lm.greaterThan(lockMode)) continue;
            lockMode = lm;
        }
        lockOptions.setLockMode(lockMode);
        return this.getForUpdateString(lockOptions);
    }

    public String getForUpdateNowaitString() {
        return this.getForUpdateString();
    }

    public String getForUpdateSkipLockedString() {
        return this.getForUpdateString();
    }

    public String getForUpdateNowaitString(String aliases) {
        return this.getForUpdateString(aliases);
    }

    public String getForUpdateSkipLockedString(String aliases) {
        return this.getForUpdateString(aliases);
    }

    public String appendLockHint(LockOptions lockOptions, String tableName) {
        return tableName;
    }

    public String applyLocksToSql(String sql, LockOptions aliasedLockOptions, Map<String, String[]> keyColumnNames) {
        return sql + new ForUpdateFragment(this, aliasedLockOptions, keyColumnNames).toFragmentString();
    }

    protected int getTimeoutInSeconds(int millis) {
        return millis == 0 ? 0 : Math.max(1, Math.round((float)millis / 1000.0f));
    }

    public String getCreateTableString() {
        return "create table";
    }

    public String getTableTypeString() {
        return "";
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public String getDropTableString(String tableName) {
        StringBuilder buf = new StringBuilder("drop table ");
        if (this.supportsIfExistsBeforeTableName()) {
            buf.append("if exists ");
        }
        buf.append(tableName).append(this.getCascadeConstraintsString());
        if (this.supportsIfExistsAfterTableName()) {
            buf.append(" if exists");
        }
        return buf.toString();
    }

    public String getCreateIndexString(boolean unique) {
        return unique ? "create unique index" : "create index";
    }

    public String getCreateIndexTail(boolean unique, List<Column> columns) {
        return "";
    }

    public boolean qualifyIndexName() {
        return true;
    }

    public String getCreateMultisetTableString() {
        return this.getCreateTableString();
    }

    public boolean hasAlterTable() {
        return true;
    }

    public String getAlterTableString(String tableName) {
        StringBuilder sb = new StringBuilder("alter table ");
        if (this.supportsIfExistsAfterAlterTable()) {
            sb.append("if exists ");
        }
        sb.append(tableName);
        return sb.toString();
    }

    public boolean supportsIfExistsAfterAlterTable() {
        return false;
    }

    public String getAddColumnString() {
        return "add column";
    }

    public String getAddColumnSuffixString() {
        return "";
    }

    public boolean dropConstraints() {
        return true;
    }

    public String getDropForeignKeyString() {
        return "drop constraint";
    }

    public String getDropUniqueKeyString() {
        return "drop constraint";
    }

    public boolean supportsIfExistsBeforeConstraintName() {
        return false;
    }

    public boolean supportsIfExistsAfterConstraintName() {
        return false;
    }

    public boolean supportsAlterColumnType() {
        return false;
    }

    public String getAlterColumnTypeString(String columnName, String columnType, String columnDefinition) {
        return null;
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        StringBuilder res = new StringBuilder(30);
        res.append(" add constraint ").append(this.quote(constraintName)).append(" foreign key (").append(String.join((CharSequence)", ", foreignKey)).append(") references ").append(referencedTable);
        if (!referencesPrimaryKey) {
            res.append(" (").append(String.join((CharSequence)", ", primaryKey)).append(')');
        }
        return res.toString();
    }

    public String getAddForeignKeyConstraintString(String constraintName, String foreignKeyDefinition) {
        return " add constraint " + this.quote(constraintName) + " " + foreignKeyDefinition;
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " add constraint " + constraintName + " primary key ";
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new PersistentTableMutationStrategy(TemporaryTable.createIdTable(entityDescriptor, basename -> "HT_" + basename, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new PersistentTableInsertStrategy(TemporaryTable.createEntityTable(entityDescriptor, name -> "HTE_" + name, this, runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public String getCreateUserDefinedTypeKindString() {
        return "";
    }

    public String getCreateUserDefinedTypeExtensionsString() {
        return "";
    }

    public boolean supportsIfExistsBeforeTypeName() {
        return false;
    }

    public boolean supportsIfExistsAfterTypeName() {
        return false;
    }

    public int registerResultSetOutParameter(CallableStatement statement, int position) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public int registerResultSetOutParameter(CallableStatement statement, String name) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public ResultSet getResultSet(CallableStatement statement) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public boolean supportsCurrentTimestampSelection() {
        return false;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        throw new UnsupportedOperationException("Database not known to define a current timestamp function");
    }

    public String getCurrentTimestampSelectString() {
        throw new UnsupportedOperationException("Database not known to define a current timestamp function");
    }

    public boolean supportsStandardCurrentTimestampFunction() {
        return true;
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return null;
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        return "null";
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsUnionInSubquery() {
        return this.supportsUnionAll();
    }

    @Deprecated(since="6")
    public String getNoColumnsInsertString() {
        return "values ( )";
    }

    public boolean supportsNoColumnsInsert() {
        return true;
    }

    public String getLowercaseFunction() {
        return "lower";
    }

    public String getCaseInsensitiveLike() {
        return "like";
    }

    public boolean supportsCaseInsensitiveLike() {
        return false;
    }

    public boolean supportsTruncateWithCast() {
        return true;
    }

    public boolean supportsIsTrue() {
        return false;
    }

    public String transformSelectString(String select) {
        return select;
    }

    public int getMaxAliasLength() {
        return 10;
    }

    public int getMaxIdentifierLength() {
        return Integer.MAX_VALUE;
    }

    public String toBooleanValueString(boolean bool) {
        StringBuilder sb = new StringBuilder();
        this.appendBooleanValueString(new StringBuilderSqlAppender(sb), bool);
        return sb.toString();
    }

    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool ? (char)'1' : '0');
    }

    protected void registerKeyword(String word) {
        this.sqlKeywords.add(word.toLowerCase(Locale.ROOT));
    }

    public Set<String> getKeywords() {
        return this.sqlKeywords;
    }

    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.applyIdentifierCasing(dbMetaData);
        builder.applyReservedWords(this.sqlKeywords);
        builder.setNameQualifierSupport(this.getNameQualifierSupport());
        return builder.build();
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public String toQuotedIdentifier(String name) {
        if (name == null) {
            return null;
        }
        return this.openQuote() + name + this.closeQuote();
    }

    public String quote(String name) {
        if (name == null) {
            return null;
        }
        if (name.charAt(0) == '`') {
            return this.openQuote() + name.substring(1, name.length() - 1) + this.closeQuote();
        }
        return name;
    }

    @Incubating
    public SchemaManagementTool getFallbackSchemaManagementTool(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        return new HibernateSchemaManagementTool();
    }

    public Exporter<Table> getTableExporter() {
        return this.tableExporter;
    }

    public TableMigrator getTableMigrator() {
        return this.tableMigrator;
    }

    public Cleaner getTableCleaner() {
        return this.tableCleaner;
    }

    public Exporter<UserDefinedType> getUserDefinedTypeExporter() {
        return this.userDefinedTypeExporter;
    }

    public Exporter<Sequence> getSequenceExporter() {
        return this.sequenceExporter;
    }

    public Exporter<Index> getIndexExporter() {
        return this.indexExporter;
    }

    public Exporter<ForeignKey> getForeignKeyExporter() {
        return this.foreignKeyExporter;
    }

    public Exporter<Constraint> getUniqueKeyExporter() {
        return this.uniqueKeyExporter;
    }

    public Exporter<AuxiliaryDatabaseObject> getAuxiliaryDatabaseObjectExporter() {
        return this.auxiliaryObjectExporter;
    }

    public TemporaryTableExporter getTemporaryTableExporter() {
        return this.temporaryTableExporter;
    }

    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return TemporaryTableKind.PERSISTENT;
    }

    public String getTemporaryTableCreateOptions() {
        return null;
    }

    public String getTemporaryTableCreateCommand() {
        TemporaryTableKind kind = this.getSupportedTemporaryTableKind();
        switch (kind) {
            case PERSISTENT: {
                return "create table";
            }
            case LOCAL: {
                return "create local temporary table";
            }
            case GLOBAL: {
                return "create global temporary table";
            }
        }
        throw new UnsupportedOperationException("Unsupported kind: " + kind);
    }

    public String getTemporaryTableDropCommand() {
        return "drop table";
    }

    public String getTemporaryTableTruncateCommand() {
        return "delete from";
    }

    public String getCreateTemporaryTableColumnAnnotation(int sqlTypeCode) {
        return "";
    }

    public TempTableDdlTransactionHandling getTemporaryTableDdlTransactionHandling() {
        return TempTableDdlTransactionHandling.NONE;
    }

    public AfterUseAction getTemporaryTableAfterUseAction() {
        return AfterUseAction.CLEAN;
    }

    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return BeforeUseAction.NONE;
    }

    public boolean canCreateCatalog() {
        return false;
    }

    public String[] getCreateCatalogCommand(String catalogName) {
        throw new UnsupportedOperationException("No create catalog syntax supported by " + this.getClass().getName());
    }

    public String[] getDropCatalogCommand(String catalogName) {
        throw new UnsupportedOperationException("No drop catalog syntax supported by " + this.getClass().getName());
    }

    public boolean canCreateSchema() {
        return true;
    }

    public String[] getCreateSchemaCommand(String schemaName) {
        return new String[]{"create schema " + schemaName};
    }

    public String[] getDropSchemaCommand(String schemaName) {
        return new String[]{"drop schema " + schemaName};
    }

    public String getCurrentSchemaCommand() {
        return null;
    }

    public SchemaNameResolver getSchemaNameResolver() {
        return DefaultSchemaNameResolver.INSTANCE;
    }

    public boolean hasSelfReferentialForeignKeyBug() {
        return false;
    }

    public String getNullColumnString() {
        return "";
    }

    public String getNullColumnString(String columnType) {
        return this.getNullColumnString();
    }

    public String quoteCollation(String collation) {
        return collation;
    }

    public boolean supportsCommentOn() {
        return false;
    }

    public String getTableComment(String comment) {
        return "";
    }

    public String getUserDefinedTypeComment(String comment) {
        return "";
    }

    public String getColumnComment(String comment) {
        return "";
    }

    public boolean supportsColumnCheck() {
        return true;
    }

    public boolean supportsTableCheck() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public String getCascadeConstraintsString() {
        return "";
    }

    public ColumnAliasExtractor getColumnAliasExtractor() {
        return ColumnAliasExtractor.COLUMN_LABEL_EXTRACTOR;
    }

    public boolean useInputStreamToInsertBlob() {
        return true;
    }

    @Deprecated(since="6", forRemoval=true)
    public boolean supportsParametersInInsertSelect() {
        return true;
    }

    public boolean supportsOrdinalSelectItemReference() {
        return true;
    }

    public NullOrdering getNullOrdering() {
        return NullOrdering.GREATEST;
    }

    public boolean supportsNullPrecedence() {
        return true;
    }

    @Deprecated(since="6")
    public boolean isAnsiNullOn() {
        return true;
    }

    public boolean requiresCastForConcatenatingNonStrings() {
        return false;
    }

    public boolean requiresFloatCastingOfIntegerDivision() {
        return false;
    }

    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return true;
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return true;
    }

    public boolean supportsSubselectAsInPredicateLHS() {
        return true;
    }

    public boolean supportsExpectedLobUsagePattern() {
        return true;
    }

    public boolean supportsLobValueChangePropagation() {
        return true;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return true;
    }

    public boolean supportsSubqueryOnMutatingTable() {
        return true;
    }

    public boolean supportsExistsInSelect() {
        return true;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return false;
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return false;
    }

    public boolean supportsBindAsCallableArgument() {
        return true;
    }

    public boolean supportsTupleCounts() {
        return false;
    }

    public boolean requiresParensForTupleCounts() {
        return this.supportsTupleCounts();
    }

    public boolean supportsTupleDistinctCounts() {
        return true;
    }

    public boolean requiresParensForTupleDistinctCounts() {
        return false;
    }

    public int getInExpressionCountLimit() {
        return 0;
    }

    public int getParameterCountLimit() {
        return this.getInExpressionCountLimit();
    }

    public boolean forceLobAsLastValue() {
        return false;
    }

    public boolean isEmptyStringTreatedAsNull() {
        return false;
    }

    public boolean useFollowOnLocking(String sql, QueryOptions queryOptions) {
        return false;
    }

    public UniqueDelegate getUniqueDelegate() {
        return new AlterTableUniqueDelegate(this);
    }

    public String getQueryHintString(String query, List<String> hintList) {
        String hints = String.join((CharSequence)", ", hintList);
        return StringHelper.isEmpty(hints) ? query : this.getQueryHintString(query, hints);
    }

    public String getQueryHintString(String query, String hints) {
        return query;
    }

    public ScrollMode defaultScrollMode() {
        return ScrollMode.SCROLL_INSENSITIVE;
    }

    public boolean supportsOffsetInSubquery() {
        return false;
    }

    public boolean supportsOrderByInSubquery() {
        return true;
    }

    public boolean supportsSubqueryInSelect() {
        return true;
    }

    public boolean supportsInsertReturning() {
        return false;
    }

    public boolean supportsInsertReturningGeneratedKeys() {
        return false;
    }

    public boolean supportsFetchClause(FetchClauseType type) {
        return false;
    }

    public boolean supportsWindowFunctions() {
        return false;
    }

    public boolean supportsLateral() {
        return false;
    }

    public CallableStatementSupport getCallableStatementSupport() {
        return StandardCallableStatementSupport.NO_REF_CURSOR_INSTANCE;
    }

    public NameQualifierSupport getNameQualifierSupport() {
        return null;
    }

    public MultiKeyLoadSizingStrategy getMultiKeyLoadSizingStrategy() {
        return this.STANDARD_MULTI_KEY_LOAD_SIZING_STRATEGY;
    }

    public MultiKeyLoadSizingStrategy getBatchLoadSizingStrategy() {
        return this.getMultiKeyLoadSizingStrategy();
    }

    public boolean isJdbcLogWarningsEnabledByDefault() {
        return true;
    }

    public void augmentPhysicalTableTypes(List<String> tableTypesList) {
    }

    public void augmentRecognizedTableTypes(List<String> tableTypesList) {
    }

    public boolean supportsPartitionBy() {
        return false;
    }

    public boolean supportsNamedParameters(DatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData != null && databaseMetaData.supportsNamedParameters();
    }

    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.EXPLICIT;
    }

    public AggregateSupport getAggregateSupport() {
        return AggregateSupportImpl.INSTANCE;
    }

    public boolean supportsStandardArrays() {
        return false;
    }

    public boolean useArrayForMultiValuedParameters() {
        return this.supportsStandardArrays() && this.getPreferredSqlTypeCodeForArray() == 2003;
    }

    public String getArrayTypeName(String javaElementTypeName, String elementTypeName, Integer maxLength) {
        if (this.supportsStandardArrays()) {
            return maxLength == null ? elementTypeName + " array" : elementTypeName + " array[" + maxLength + "]";
        }
        return null;
    }

    public void appendArrayLiteral(SqlAppender appender, Object[] literal, JdbcLiteralFormatter<Object> elementFormatter, WrapperOptions wrapperOptions) {
        if (!this.supportsStandardArrays()) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not support array literals");
        }
        appender.appendSql("ARRAY[");
        if (literal.length != 0) {
            if (literal[0] == null) {
                appender.appendSql("null");
            } else {
                elementFormatter.appendJdbcLiteral(appender, literal[0], this, wrapperOptions);
            }
            for (int i = 1; i < literal.length; ++i) {
                appender.appendSql(',');
                if (literal[i] == null) {
                    appender.appendSql("null");
                    continue;
                }
                elementFormatter.appendJdbcLiteral(appender, literal[i], this, wrapperOptions);
            }
        }
        appender.appendSql(']');
    }

    public boolean supportsDistinctFromPredicate() {
        return false;
    }

    public int getPreferredSqlTypeCodeForArray() {
        return this.supportsStandardArrays() ? 2003 : -3;
    }

    public int getPreferredSqlTypeCodeForBoolean() {
        return 16;
    }

    public boolean supportsNonQueryWithCTE() {
        return false;
    }

    public boolean supportsRecursiveCTE() {
        return false;
    }

    public boolean supportsValuesList() {
        return false;
    }

    public boolean supportsValuesListForInsert() {
        return true;
    }

    public boolean supportsSkipLocked() {
        return false;
    }

    public boolean supportsNoWait() {
        return false;
    }

    public boolean supportsWait() {
        return this.supportsNoWait();
    }

    @Deprecated(since="6", forRemoval=true)
    public String inlineLiteral(String literal) {
        StringBuilder sb = new StringBuilder(literal.length() + 2);
        this.appendLiteral(new StringBuilderSqlAppender(sb), literal);
        return sb.toString();
    }

    public void appendLiteral(SqlAppender appender, String literal) {
        appender.appendSql('\'');
        for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            if (c == '\'') {
                appender.appendSql('\'');
            }
            appender.appendSql(c);
        }
        appender.appendSql('\'');
    }

    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("X'");
        PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
        appender.appendSql('\'');
    }

    public boolean supportsJdbcConnectionLobCreation(DatabaseMetaData databaseMetaData) {
        return true;
    }

    public boolean supportsMaterializedLobAccess() {
        return true;
    }

    public boolean useMaterializedLobWhenCapacityExceeded() {
        return this.supportsMaterializedLobAccess();
    }

    public String addSqlHintOrComment(String sql, QueryOptions queryOptions, boolean commentsEnabled) {
        if (queryOptions.getDatabaseHints() != null && queryOptions.getDatabaseHints().size() > 0) {
            sql = this.getQueryHintString(sql, queryOptions.getDatabaseHints());
        }
        if (commentsEnabled && queryOptions.getComment() != null) {
            sql = this.prependComment(sql, queryOptions.getComment());
        }
        return sql;
    }

    protected String prependComment(String sql, String comment) {
        return "/* " + Dialect.escapeComment(comment) + " */ " + sql;
    }

    public static String escapeComment(String comment) {
        if (StringHelper.isNotEmpty(comment)) {
            String escaped = ESCAPE_CLOSING_COMMENT_PATTERN.matcher(comment).replaceAll("*\\\\/");
            return ESCAPE_OPENING_COMMENT_PATTERN.matcher(escaped).replaceAll("/\\\\*");
        }
        return comment;
    }

    public HqlTranslator getHqlTranslator() {
        return null;
    }

    public SqmTranslatorFactory getSqmTranslatorFactory() {
        return null;
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return null;
    }

    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.EXPRESSION;
    }

    public SizeStrategy getSizeStrategy() {
        return this.sizeStrategy;
    }

    public int getMaxVarcharLength() {
        return Integer.MAX_VALUE;
    }

    public int getMaxNVarcharLength() {
        return this.getMaxVarcharLength();
    }

    public int getMaxVarbinaryLength() {
        return this.getMaxVarcharLength();
    }

    public int getMaxVarcharCapacity() {
        return this.getMaxVarcharLength();
    }

    public int getMaxNVarcharCapacity() {
        return this.getMaxNVarcharLength();
    }

    public int getMaxVarbinaryCapacity() {
        return this.getMaxVarbinaryLength();
    }

    public long getDefaultLobLength() {
        return 0x100000L;
    }

    public int getDefaultDecimalPrecision() {
        return 38;
    }

    public int getDefaultTimestampPrecision() {
        return 6;
    }

    public int getFloatPrecision() {
        return 24;
    }

    public int getDoublePrecision() {
        return 53;
    }

    public long getFractionalSecondPrecisionInNanos() {
        return 1L;
    }

    public boolean supportsBitType() {
        return true;
    }

    protected boolean supportsPredicateAsExpression() {
        return true;
    }

    public RowLockStrategy getLockRowIdentifier(LockMode lockMode) {
        switch (lockMode) {
            case PESSIMISTIC_READ: {
                return this.getReadRowLockStrategy();
            }
            case PESSIMISTIC_FORCE_INCREMENT: 
            case PESSIMISTIC_WRITE: 
            case UPGRADE_NOWAIT: 
            case UPGRADE_SKIPLOCKED: 
            case WRITE: {
                return this.getWriteRowLockStrategy();
            }
        }
        return RowLockStrategy.NONE;
    }

    public String generatedAs(String generatedAs) {
        return " generated always as (" + generatedAs + ") stored";
    }

    public boolean hasDataTypeBeforeGeneratedAs() {
        return true;
    }

    public MutationOperation createOptionalTableUpdateOperation(EntityMutationTarget mutationTarget, OptionalTableUpdate optionalTableUpdate, SessionFactoryImplementor factory) {
        return new OptionalTableUpdateOperation(mutationTarget, optionalTableUpdate, factory);
    }

    public boolean canDisableConstraints() {
        return false;
    }

    public String getDisableConstraintsStatement() {
        return null;
    }

    public String getEnableConstraintsStatement() {
        return null;
    }

    public String getDisableConstraintStatement(String tableName, String name) {
        return null;
    }

    public String getEnableConstraintStatement(String tableName, String name) {
        return null;
    }

    public boolean canBatchTruncate() {
        return false;
    }

    public String[] getTruncateTableStatements(String[] tableNames) {
        if (this.canBatchTruncate()) {
            StringBuilder builder = new StringBuilder();
            for (String tableName : tableNames) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(tableName);
            }
            return new String[]{this.getTruncateTableStatement(builder.toString())};
        }
        String[] statements = new String[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            statements[i] = this.getTruncateTableStatement(tableNames[i]);
        }
        return statements;
    }

    public String getTruncateTableStatement(String tableName) {
        return "truncate table " + tableName;
    }

    public ParameterMarkerStrategy getNativeParameterMarkerStrategy() {
        return null;
    }

    public Boolean supportsBatchUpdates() {
        return true;
    }

    public Boolean supportsRefCursors() {
        return null;
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat(format, true, false).result());
    }

    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "dd";
            }
            case DAY_OF_YEAR: {
                return "dy";
            }
            case DAY_OF_WEEK: {
                return "dw";
            }
            case OFFSET: 
            case NATIVE: 
            case NANOSECOND: 
            case DATE: 
            case TIME: 
            case WEEK_OF_MONTH: 
            case WEEK_OF_YEAR: {
                throw new IllegalArgumentException("illegal field: " + unit);
            }
        }
        return unit.toString();
    }

    public String translateDurationField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: 
            case DAY_OF_YEAR: 
            case DAY_OF_WEEK: 
            case OFFSET: 
            case DATE: 
            case TIME: 
            case WEEK_OF_MONTH: 
            case WEEK_OF_YEAR: 
            case TIMEZONE_HOUR: 
            case TIMEZONE_MINUTE: {
                throw new IllegalArgumentException("illegal unit: " + unit);
            }
            case NATIVE: {
                return "nanosecond";
            }
        }
        return unit.toString();
    }

    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("{d '");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql("'}");
                break;
            }
            case TIME: {
                appender.appendSql("{t '");
                DateTimeUtils.appendAsTime(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("{ts '");
                DateTimeUtils.appendAsTimestampWithNanos(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("{d '");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql("'}");
                break;
            }
            case TIME: {
                appender.appendSql("{t '");
                DateTimeUtils.appendAsLocalTime(appender, date);
                appender.appendSql("'}");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("{ts '");
                DateTimeUtils.appendAsTimestampWithNanos(appender, date, jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("{d '");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql("'}");
                break;
            }
            case TIME: {
                appender.appendSql("{t '");
                DateTimeUtils.appendAsLocalTime(appender, calendar);
                appender.appendSql("'}");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("{ts '");
                DateTimeUtils.appendAsTimestampWithMillis(appender, calendar, jdbcTimeZone);
                appender.appendSql("'}");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendIntervalLiteral(SqlAppender appender, Duration literal) {
        appender.appendSql("interval '");
        appender.appendSql(literal.getSeconds());
        appender.appendSql('.');
        appender.appendSql(literal.getNano());
        appender.appendSql("' second");
    }

    public void appendUUIDLiteral(SqlAppender appender, UUID literal) {
        appender.appendSql("cast('");
        appender.appendSql(literal.toString());
        appender.appendSql("' as uuid)");
    }

    public boolean supportsTemporalLiteralOffset() {
        return false;
    }

    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NONE;
    }

    public String rowId(String rowId) {
        return null;
    }

    public int rowIdSqlType() {
        return -8;
    }

    public String getRowIdColumnString(String rowId) {
        return null;
    }

    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.NONE;
    }

    public FunctionalDependencyAnalysisSupport getFunctionalDependencyAnalysisSupport() {
        return FunctionalDependencyAnalysisSupportImpl.NONE;
    }

    public int getDefaultIntervalSecondScale() {
        return 9;
    }

    public class SizeStrategyImpl
    implements SizeStrategy {
        @Override
        public Size resolveSize(JdbcType jdbcType, JavaType<?> javaType, Integer precision, Integer scale, Long length) {
            Size size = new Size();
            int ddlTypeCode = jdbcType.getDdlTypeCode();
            if (length != null && length == 255L) {
                length = null;
            }
            switch (ddlTypeCode) {
                case 2003: {
                    break;
                }
                case -15: 
                case -9: 
                case -7: 
                case -3: 
                case -2: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    size.setLength(javaType.getDefaultSqlLength(Dialect.this, jdbcType));
                    break;
                }
                case -16: 
                case -4: 
                case -1: {
                    size.setLength(javaType.getLongSqlLength());
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    length = null;
                    size.setPrecision(javaType.getDefaultSqlPrecision(Dialect.this, jdbcType));
                    if (scale != null && scale != 0) {
                        throw new IllegalArgumentException("scale has no meaning for SQL floating point types");
                    }
                    if (precision == null) break;
                    precision = (int)Math.ceil((double)precision.intValue() * LOG_BASE2OF10);
                    break;
                }
                case 92: 
                case 93: 
                case 2013: 
                case 2014: 
                case 3003: 
                case 3007: {
                    length = null;
                    size.setPrecision(javaType.getDefaultSqlPrecision(Dialect.this, jdbcType));
                    if (scale == null || scale == 0) break;
                    throw new IllegalArgumentException("scale has no meaning for SQL time or timestamp types");
                }
                case 2: 
                case 3: 
                case 3100: {
                    size.setPrecision(javaType.getDefaultSqlPrecision(Dialect.this, jdbcType));
                    size.setScale(javaType.getDefaultSqlScale(Dialect.this, jdbcType));
                }
            }
            if (precision != null) {
                size.setPrecision(precision);
            }
            if (scale != null) {
                size.setScale(scale);
            }
            if (length != null) {
                size.setLength(length);
            }
            return size;
        }
    }

    public static interface SizeStrategy {
        public Size resolveSize(JdbcType var1, JavaType<?> var2, Integer var3, Integer var4, Long var5);
    }
}

