/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSyncWorkOrchestrator;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.extraction.impl.ExtractionRequirements;
import org.hibernate.search.backend.lucene.search.highlighter.impl.LuceneAbstractSearchHighlighter;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchQuery;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryImpl;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryIndexScope;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryRequestContext;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearcherImpl;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortCollector;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneFieldComparatorSource;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.highlighter.SearchHighlighter;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContext;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneSearchQueryBuilder<H>
implements SearchQueryBuilder<H>,
LuceneSearchSortCollector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneWorkFactory workFactory;
    private final LuceneSyncWorkOrchestrator queryOrchestrator;
    private final LuceneSearchQueryIndexScope<?> scope;
    private final BackendSessionContext sessionContext;
    private final Set<String> routingKeys;
    private final SearchLoadingContextBuilder<?, ?> loadingContextBuilder;
    private final LuceneSearchProjection<H> rootProjection;
    private Query luceneQuery;
    private List<SortField> sortFields;
    private Map<AggregationKey<?>, LuceneSearchAggregation<?>> aggregations;
    private Long timeout;
    private TimeUnit timeUnit;
    private boolean exceptionOnTimeout;
    private Long totalHitCountThreshold;
    private LuceneAbstractSearchHighlighter globalHighlighter;
    private final Map<String, LuceneAbstractSearchHighlighter> namedHighlighters = new HashMap<String, LuceneAbstractSearchHighlighter>();

    public LuceneSearchQueryBuilder(LuceneWorkFactory workFactory, LuceneSyncWorkOrchestrator queryOrchestrator, LuceneSearchQueryIndexScope<?> scope, BackendSessionContext sessionContext, SearchLoadingContextBuilder<?, ?> loadingContextBuilder, LuceneSearchProjection<H> rootProjection) {
        this.workFactory = workFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.scope = scope;
        this.sessionContext = sessionContext;
        this.routingKeys = new HashSet<String>();
        this.loadingContextBuilder = loadingContextBuilder;
        this.rootProjection = rootProjection;
    }

    public void predicate(SearchPredicate predicate) {
        LuceneSearchPredicate lucenePredicate = LuceneSearchPredicate.from(this.scope, predicate);
        this.luceneQuery = lucenePredicate.toQuery(PredicateRequestContext.root());
    }

    public void sort(SearchSort sort) {
        LuceneSearchSort luceneSort = LuceneSearchSort.from(this.scope, sort);
        luceneSort.toSortFields(this);
    }

    public <A> void aggregation(AggregationKey<A> key, SearchAggregation<A> aggregation) {
        LuceneSearchAggregation previous;
        if (!(aggregation instanceof LuceneSearchAggregation)) {
            throw log.cannotMixLuceneSearchQueryWithOtherAggregations(aggregation);
        }
        LuceneSearchAggregation casted = (LuceneSearchAggregation)aggregation;
        if (!this.scope.hibernateSearchIndexNames().equals(casted.getIndexNames())) {
            throw log.aggregationDefinedOnDifferentIndexes(aggregation, casted.getIndexNames(), this.scope.hibernateSearchIndexNames());
        }
        if (this.aggregations == null) {
            this.aggregations = new LinkedHashMap();
        }
        if ((previous = this.aggregations.put(key, casted)) != null) {
            throw log.duplicateAggregationKey(key);
        }
    }

    public void addRoutingKey(String routingKey) {
        this.routingKeys.add(routingKey);
    }

    public void truncateAfter(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.exceptionOnTimeout = false;
    }

    public void failAfter(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.exceptionOnTimeout = true;
    }

    public void totalHitCountThreshold(long totalHitCountThreshold) {
        this.totalHitCountThreshold = totalHitCountThreshold;
    }

    public void highlighter(SearchHighlighter queryHighlighter) {
        this.globalHighlighter = LuceneAbstractSearchHighlighter.from(this.scope, queryHighlighter);
    }

    public void highlighter(String highlighterName, SearchHighlighter highlighter) {
        if (highlighterName == null || highlighterName.trim().isEmpty()) {
            throw log.highlighterNameCannotBeBlank();
        }
        if (this.namedHighlighters.put(highlighterName, LuceneAbstractSearchHighlighter.from(this.scope, highlighter)) != null) {
            throw log.highlighterWithTheSameNameCannotBeAdded(highlighterName);
        }
    }

    @Override
    public void collectSortField(SortField sortField) {
        if (this.sortFields == null) {
            this.sortFields = new ArrayList<SortField>(5);
        }
        this.sortFields.add(sortField);
    }

    @Override
    public void collectSortField(SortField sortField, LuceneFieldComparatorSource nestedFieldSort) {
        this.collectSortField(sortField);
    }

    @Override
    public void collectSortFields(SortField[] sortFields) {
        if (sortFields == null || sortFields.length == 0) {
            return;
        }
        if (this.sortFields == null) {
            this.sortFields = new ArrayList<SortField>(sortFields.length);
        }
        Collections.addAll(this.sortFields, sortFields);
    }

    public LuceneSearchQuery<H> build() {
        Query filter;
        SearchLoadingContext loadingContext = this.loadingContextBuilder.build();
        BooleanQuery.Builder luceneQueryBuilder = new BooleanQuery.Builder();
        luceneQueryBuilder.add(this.luceneQuery, BooleanClause.Occur.MUST);
        if (this.scope.hasNestedDocuments()) {
            luceneQueryBuilder.add(Queries.mainDocumentQuery(), BooleanClause.Occur.FILTER);
        }
        if (!this.routingKeys.isEmpty()) {
            Query routingKeysQuery = Queries.anyTerm(MetadataFields.routingKeyFieldName(), this.routingKeys);
            luceneQueryBuilder.add(routingKeysQuery, BooleanClause.Occur.FILTER);
        }
        if ((filter = this.scope.filterOrNull(this.sessionContext.tenantIdentifier())) != null) {
            luceneQueryBuilder.add(filter, BooleanClause.Occur.FILTER);
        }
        BooleanQuery definitiveLuceneQuery = luceneQueryBuilder.build();
        Sort luceneSort = null;
        if (this.sortFields != null && !this.sortFields.isEmpty()) {
            luceneSort = new Sort(this.sortFields.toArray(new SortField[0]));
        }
        LuceneSearchQueryRequestContext requestContext = new LuceneSearchQueryRequestContext(this.sessionContext, loadingContext, (Query)definitiveLuceneQuery, luceneSort);
        LuceneAbstractSearchHighlighter resolvedGlobalHighlighter = this.globalHighlighter == null ? null : this.globalHighlighter.withFallbackDefaults();
        HashMap<String, LuceneAbstractSearchHighlighter> resolvedNamedHighlighters = new HashMap<String, LuceneAbstractSearchHighlighter>();
        if (resolvedGlobalHighlighter != null) {
            for (Map.Entry<String, LuceneAbstractSearchHighlighter> entry : this.namedHighlighters.entrySet()) {
                resolvedNamedHighlighters.put(entry.getKey(), entry.getValue().withFallback(resolvedGlobalHighlighter));
            }
        } else {
            for (Map.Entry<String, LuceneAbstractSearchHighlighter> entry : this.namedHighlighters.entrySet()) {
                resolvedNamedHighlighters.put(entry.getKey(), entry.getValue().withFallbackDefaults());
            }
        }
        ExtractionRequirements.Builder extractionRequirementsBuilder = new ExtractionRequirements.Builder();
        ProjectionRequestContext projectionRequestContext = new ProjectionRequestContext(extractionRequirementsBuilder, resolvedGlobalHighlighter, resolvedNamedHighlighters);
        LuceneSearchProjection.Extractor<?, H> rootExtractor = this.rootProjection.request(projectionRequestContext);
        if (this.aggregations != null) {
            AggregationRequestContext aggregationRequestContext = new AggregationRequestContext(extractionRequirementsBuilder);
            for (LuceneSearchAggregation<?> aggregation : this.aggregations.values()) {
                aggregation.request(aggregationRequestContext);
            }
        }
        ExtractionRequirements extractionRequirements = extractionRequirementsBuilder.build();
        TimeoutManager timeoutManager = this.scope.createTimeoutManager(this.timeout, this.timeUnit, this.exceptionOnTimeout);
        LuceneSearcherImpl<H> searcher = new LuceneSearcherImpl<H>(requestContext, rootExtractor, this.aggregations == null ? Collections.emptyMap() : this.aggregations, extractionRequirements, timeoutManager);
        return new LuceneSearchQueryImpl(this.queryOrchestrator, this.workFactory, this.scope, this.sessionContext, loadingContext, this.routingKeys, timeoutManager, (Query)definitiveLuceneQuery, luceneSort, searcher, this.totalHitCountThreshold);
    }
}

