/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.query.interceptor;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.utils.StringUtils;

@SdkProtectedApi
public final class QueryParametersToBodyInterceptor
implements ExecutionInterceptor {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-www-form-urlencoded; charset=" + StringUtils.lowerCase((String)StandardCharsets.UTF_8.toString());

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpRequest httpRequest = context.httpRequest();
        if (!(httpRequest instanceof SdkHttpFullRequest)) {
            return httpRequest;
        }
        SdkHttpFullRequest httpFullRequest = (SdkHttpFullRequest)httpRequest;
        if (this.shouldPutParamsInBody(httpFullRequest)) {
            return this.changeQueryParametersToFormData(httpFullRequest);
        }
        return httpFullRequest;
    }

    private boolean shouldPutParamsInBody(SdkHttpFullRequest input) {
        return input.method() == SdkHttpMethod.POST && !input.contentStreamProvider().isPresent() && input.numRawQueryParameters() > 0;
    }

    private SdkHttpRequest changeQueryParametersToFormData(SdkHttpFullRequest input) {
        byte[] params = input.encodedQueryParametersAsFormData().orElse("").getBytes(StandardCharsets.UTF_8);
        return input.toBuilder().clearQueryParameters().contentStreamProvider(() -> new ByteArrayInputStream(params)).putHeader("Content-Length", Collections.singletonList(String.valueOf(params.length))).putHeader("Content-Type", Collections.singletonList(DEFAULT_CONTENT_TYPE)).build();
    }
}

