/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.unique;

import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;

public class AlterTableUniqueDelegate
implements UniqueDelegate {
    protected final Dialect dialect;

    public AlterTableUniqueDelegate(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String getColumnDefinitionUniquenessFragment(Column column, SqlStringGenerationContext context) {
        return "";
    }

    @Override
    public String getTableCreationUniqueConstraintsFragment(Table table, SqlStringGenerationContext context) {
        return "";
    }

    @Override
    public String getAlterTableToAddUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata, SqlStringGenerationContext context) {
        String tableName = context.format(uniqueKey.getTable().getQualifiedTableName());
        String constraintName = this.dialect.quote(uniqueKey.getName());
        return this.dialect.getAlterTableString(tableName) + " add constraint " + constraintName + " " + this.uniqueConstraintSql(uniqueKey);
    }

    protected String uniqueConstraintSql(UniqueKey uniqueKey) {
        StringBuilder fragment = new StringBuilder();
        fragment.append("unique (");
        boolean first = true;
        for (Column column : uniqueKey.getColumns()) {
            if (first) {
                first = false;
            } else {
                fragment.append(", ");
            }
            fragment.append(column.getQuotedName(this.dialect));
            if (!uniqueKey.getColumnOrderMap().containsKey(column)) continue;
            fragment.append(" ").append(uniqueKey.getColumnOrderMap().get(column));
        }
        return fragment.append(')').toString();
    }

    @Override
    public String getAlterTableToDropUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata, SqlStringGenerationContext context) {
        String tableName = context.format(uniqueKey.getTable().getQualifiedTableName());
        StringBuilder command = new StringBuilder(this.dialect.getAlterTableString(tableName));
        command.append(' ');
        command.append(this.dialect.getDropUniqueKeyString());
        if (this.dialect.supportsIfExistsBeforeConstraintName()) {
            command.append(" if exists ");
            command.append(this.dialect.quote(uniqueKey.getName()));
        } else if (this.dialect.supportsIfExistsAfterConstraintName()) {
            command.append(' ');
            command.append(this.dialect.quote(uniqueKey.getName()));
            command.append(" if exists");
        } else {
            command.append(' ');
            command.append(this.dialect.quote(uniqueKey.getName()));
        }
        return command.toString();
    }
}

