/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.annotations.ResultCheckStyle;

public enum ExecuteUpdateResultCheckStyle {
    NONE("none"),
    COUNT("rowcount"),
    PARAM("param");

    private final @UnknownKeyFor @NonNull @Initialized String name;

    private ExecuteUpdateResultCheckStyle(String name) {
        this.name = name;
    }

    public @UnknownKeyFor @NonNull @Initialized String externalName() {
        return this.name;
    }

    public static @Nullable @UnknownKeyFor @Initialized ExecuteUpdateResultCheckStyle fromResultCheckStyle(@UnknownKeyFor @NonNull @Initialized ResultCheckStyle style) {
        switch (style) {
            case NONE: {
                return NONE;
            }
            case COUNT: {
                return COUNT;
            }
            case PARAM: {
                return PARAM;
            }
        }
        return null;
    }

    public static @Nullable @UnknownKeyFor @Initialized ExecuteUpdateResultCheckStyle fromExternalName(@UnknownKeyFor @NonNull @Initialized String name) {
        if (name.equalsIgnoreCase(ExecuteUpdateResultCheckStyle.NONE.name)) {
            return NONE;
        }
        if (name.equalsIgnoreCase(ExecuteUpdateResultCheckStyle.COUNT.name)) {
            return COUNT;
        }
        if (name.equalsIgnoreCase(ExecuteUpdateResultCheckStyle.PARAM.name)) {
            return PARAM;
        }
        return null;
    }

    public static @UnknownKeyFor @NonNull @Initialized ExecuteUpdateResultCheckStyle determineDefault(@Nullable @UnknownKeyFor @Initialized String customSql, @UnknownKeyFor @NonNull @Initialized boolean callable) {
        return customSql != null && callable ? PARAM : COUNT;
    }
}

