/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class JoinedList<E>
extends AbstractList<E> {
    private final List<List<E>> lists;
    private final int size;

    public JoinedList(List<List<E>> lists) {
        this.lists = lists;
        this.size = lists.stream().map(List::size).reduce(0, Integer::sum);
    }

    @SafeVarargs
    public JoinedList(List<E> ... lists) {
        this(Arrays.asList(lists));
    }

    @Override
    public E get(int index) {
        for (List<E> list : this.lists) {
            if (list.size() > index) {
                return list.get(index);
            }
            index -= list.size();
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<E> iterator() {
        return this.lists.stream().flatMap(Collection::stream).iterator();
    }
}

