/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class LinkedIdentityHashMap<K, V>
extends IdentityHashMap<K, V> {
    private final ArraySet<K> orderedKeys = new ArraySet();

    @Override
    public V put(K key, V value) {
        this.orderedKeys.add(key);
        return super.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.orderedKeys.remove(key);
        return super.remove(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean removed = super.remove(key, value);
        if (removed) {
            this.orderedKeys.remove(key);
        }
        return removed;
    }

    @Override
    public void clear() {
        this.orderedKeys.clear();
        super.clear();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.orderedKeys);
    }

    @Override
    public Collection<V> values() {
        return this.orderedKeys.stream().map(this::get).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.orderedKeys.stream().map(key -> Map.entry(key, this.get(key))).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    private static final class ArraySet<E>
    extends ArrayList<E>
    implements Set<E> {
        private ArraySet() {
        }
    }
}

