/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.lang.reflect.Constructor;
import org.hibernate.InstantiationException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.internal.AbstractPojoInstantiator;
import org.hibernate.metamodel.internal.EmbeddableHelper;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.metamodel.spi.ValueAccess;

public class EmbeddableInstantiatorPojoIndirecting
extends AbstractPojoInstantiator
implements EmbeddableInstantiator {
    protected final Constructor<?> constructor;
    protected final int[] index;

    protected EmbeddableInstantiatorPojoIndirecting(Constructor<?> constructor, int[] index) {
        super(constructor.getDeclaringClass());
        this.constructor = constructor;
        this.index = index;
    }

    public static EmbeddableInstantiatorPojoIndirecting of(String[] propertyNames, Constructor<?> constructor, String[] componentNames) {
        if (componentNames == null) {
            throw new IllegalArgumentException("Can't determine field assignment for constructor: " + constructor);
        }
        int[] index = new int[componentNames.length];
        if (EmbeddableHelper.resolveIndex(propertyNames, componentNames, index)) {
            return new EmbeddableInstantiatorPojoIndirectingWithGap(constructor, index);
        }
        return new EmbeddableInstantiatorPojoIndirecting(constructor, index);
    }

    @Override
    public Object instantiate(ValueAccess valuesAccess, SessionFactoryImplementor sessionFactory) {
        try {
            Object[] originalValues = valuesAccess.getValues();
            Object[] values = new Object[originalValues.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = originalValues[this.index[i]];
            }
            return this.constructor.newInstance(values);
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate entity", this.getMappedPojoClass(), e);
        }
    }

    private static class EmbeddableInstantiatorPojoIndirectingWithGap
    extends EmbeddableInstantiatorPojoIndirecting {
        public EmbeddableInstantiatorPojoIndirectingWithGap(Constructor<?> constructor, int[] index) {
            super(constructor, index);
        }

        @Override
        public Object instantiate(ValueAccess valuesAccess, SessionFactoryImplementor sessionFactory) {
            try {
                Object[] originalValues = valuesAccess.getValues();
                Object[] values = new Object[this.index.length];
                for (int i = 0; i < values.length; ++i) {
                    int index = this.index[i];
                    if (index < 0) continue;
                    values[i] = originalValues[index];
                }
                return this.constructor.newInstance(values);
            }
            catch (Exception e) {
                throw new InstantiationException("Could not instantiate entity", this.getMappedPojoClass(), e);
            }
        }
    }
}

