/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection.mutation;

import java.util.Collection;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.persister.collection.OneToManyPersister;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.CollectionTableMapping;
import org.hibernate.persister.collection.mutation.OperationProducer;
import org.hibernate.persister.collection.mutation.RemoveCoordinator;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.internal.MutationOperationGroupFactory;

public class RemoveCoordinatorTablePerSubclass
implements RemoveCoordinator {
    private final OneToManyPersister mutationTarget;
    private final OperationProducer operationProducer;
    private final MutationExecutorService mutationExecutorService;
    private MutationOperationGroup[] operationGroups;

    public RemoveCoordinatorTablePerSubclass(OneToManyPersister mutationTarget, OperationProducer operationProducer, ServiceRegistry serviceRegistry) {
        this.mutationTarget = mutationTarget;
        this.operationProducer = operationProducer;
        this.mutationExecutorService = serviceRegistry.getService(MutationExecutorService.class);
    }

    public String toString() {
        return "RemoveCoordinator(" + this.mutationTarget.getRolePath() + ")";
    }

    @Override
    public CollectionMutationTarget getMutationTarget() {
        return this.mutationTarget;
    }

    @Override
    public String getSqlString() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllRows(Object key, SharedSessionContractImplementor session) {
        MutationOperationGroup[] operationGroups;
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Deleting collection - %s : %s", (Object)this.mutationTarget.getRolePath(), key);
        }
        if ((operationGroups = this.operationGroups) == null) {
            operationGroups = this.operationGroups = this.buildOperationGroups();
        }
        ForeignKeyDescriptor fkDescriptor = this.mutationTarget.getTargetPart().getKeyDescriptor();
        for (MutationOperationGroup operationGroup : operationGroups) {
            MutationExecutor mutationExecutor = this.mutationExecutorService.createExecutor(() -> null, operationGroup, session);
            try {
                fkDescriptor.getKeyPart().decompose(key, 0, mutationExecutor.getJdbcValueBindings(), null, RowMutationOperations.DEFAULT_RESTRICTOR, session);
                mutationExecutor.execute(key, null, null, null, session);
            }
            finally {
                mutationExecutor.release();
            }
        }
    }

    private MutationOperationGroup[] buildOperationGroups() {
        Collection<EntityMappingType> subMappingTypes = this.mutationTarget.getElementPersister().getRootEntityDescriptor().getSubMappingTypes();
        MutationOperationGroup[] operationGroups = new MutationOperationGroup[subMappingTypes.size()];
        int i = 0;
        for (EntityMappingType subMappingType : subMappingTypes) {
            operationGroups[i++] = this.buildOperationGroup(subMappingType.getEntityPersister());
        }
        return operationGroups;
    }

    private MutationOperationGroup buildOperationGroup(EntityPersister elementPersister) {
        assert (this.mutationTarget.getTargetPart() != null);
        assert (this.mutationTarget.getTargetPart().getKeyDescriptor() != null);
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isTraceEnabled()) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Starting RemoveCoordinator#buildOperationGroup - %s", (Object)this.mutationTarget.getRolePath());
        }
        CollectionTableMapping collectionTableMapping = this.mutationTarget.getCollectionTableMapping();
        MutatingTableReference tableReference = new MutatingTableReference(new CollectionTableMapping(elementPersister.getMappedTableDetails().getTableName(), collectionTableMapping.getSpaces(), collectionTableMapping.isJoinTable(), collectionTableMapping.isInverse(), collectionTableMapping.getInsertDetails(), collectionTableMapping.getUpdateDetails(), collectionTableMapping.isCascadeDeleteEnabled(), collectionTableMapping.getDeleteDetails(), collectionTableMapping.getDeleteRowDetails()));
        return MutationOperationGroupFactory.singleOperation(MutationType.DELETE, this.mutationTarget, this.operationProducer.createOperation(tableReference));
    }
}

