/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.spi.PersisterClassResolver;
import org.hibernate.persister.spi.PersisterCreationContext;
import org.hibernate.persister.spi.PersisterFactory;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public final class PersisterFactoryImpl
implements PersisterFactory,
ServiceRegistryAwareService {
    public static final Class<?>[] ENTITY_PERSISTER_CONSTRUCTOR_ARGS = new Class[]{PersistentClass.class, EntityDataAccess.class, NaturalIdDataAccess.class, RuntimeModelCreationContext.class};
    public static final Class<?>[] COLLECTION_PERSISTER_CONSTRUCTOR_ARGS = new Class[]{Collection.class, CollectionDataAccess.class, RuntimeModelCreationContext.class};
    private PersisterClassResolver persisterClassResolver;
    @Deprecated(since="6.0")
    private static final Class<?>[] LEGACY_ENTITY_PERSISTER_CONSTRUCTOR_ARGS = new Class[]{PersistentClass.class, EntityDataAccess.class, NaturalIdDataAccess.class, PersisterCreationContext.class};
    @Deprecated(since="6.0")
    private static final Class<?>[] LEGACY_COLLECTION_PERSISTER_CONSTRUCTOR_ARGS = new Class[]{Collection.class, CollectionDataAccess.class, PersisterCreationContext.class};

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.persisterClassResolver = serviceRegistry.getService(PersisterClassResolver.class);
    }

    @Override
    public EntityPersister createEntityPersister(PersistentClass entityBinding, EntityDataAccess entityCacheAccessStrategy, NaturalIdDataAccess naturalIdCacheAccessStrategy, RuntimeModelCreationContext creationContext) {
        Class<? extends EntityPersister> persisterClass = entityBinding.getEntityPersisterClass();
        if (persisterClass == null) {
            persisterClass = this.persisterClassResolver.getEntityPersisterClass(entityBinding);
        }
        return this.createEntityPersister(persisterClass, entityBinding, entityCacheAccessStrategy, naturalIdCacheAccessStrategy, creationContext);
    }

    private EntityPersister createEntityPersister(Class<? extends EntityPersister> persisterClass, PersistentClass entityBinding, EntityDataAccess entityCacheAccessStrategy, NaturalIdDataAccess naturalIdCacheAccessStrategy, RuntimeModelCreationContext creationContext) {
        Constructor<? extends EntityPersister> constructor = this.resolveEntityPersisterConstructor(persisterClass);
        try {
            return constructor.newInstance(entityBinding, entityCacheAccessStrategy, naturalIdCacheAccessStrategy, creationContext);
        }
        catch (MappingException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof HibernateException) {
                throw (HibernateException)((Object)target);
            }
            throw new MappingException("Could not instantiate persister " + persisterClass.getName(), target);
        }
        catch (Exception e) {
            throw new MappingException("Could not instantiate persister " + persisterClass.getName(), e);
        }
    }

    private Constructor<? extends EntityPersister> resolveEntityPersisterConstructor(Class<? extends EntityPersister> persisterClass) {
        try {
            return persisterClass.getConstructor(ENTITY_PERSISTER_CONSTRUCTOR_ARGS);
        }
        catch (NoSuchMethodException noConstructorException) {
            try {
                Constructor<? extends EntityPersister> constructor = persisterClass.getConstructor(LEGACY_ENTITY_PERSISTER_CONSTRUCTOR_ARGS);
                DeprecationLogger.DEPRECATION_LOGGER.debugf("EntityPersister implementation defined constructor using legacy signature using `%s`; use `%s` instead", PersisterCreationContext.class.getName(), RuntimeModelCreationContext.class.getName());
                return constructor;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new MappingException("Could not find appropriate constructor for " + persisterClass.getName(), noConstructorException);
            }
        }
    }

    @Override
    public CollectionPersister createCollectionPersister(Collection collectionBinding, CollectionDataAccess cacheAccessStrategy, RuntimeModelCreationContext creationContext) {
        Class<? extends CollectionPersister> persisterClass = collectionBinding.getCollectionPersisterClass();
        if (persisterClass == null) {
            persisterClass = this.persisterClassResolver.getCollectionPersisterClass(collectionBinding);
        }
        return this.createCollectionPersister(persisterClass, collectionBinding, cacheAccessStrategy, creationContext);
    }

    private CollectionPersister createCollectionPersister(Class<? extends CollectionPersister> persisterClass, Collection collectionBinding, CollectionDataAccess cacheAccessStrategy, PersisterCreationContext creationContext) {
        Constructor<? extends CollectionPersister> constructor = this.resolveCollectionPersisterConstructor(persisterClass);
        try {
            return constructor.newInstance(collectionBinding, cacheAccessStrategy, creationContext);
        }
        catch (MappingException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof HibernateException) {
                throw (HibernateException)((Object)target);
            }
            throw new MappingException(String.format("Could not instantiate collection persister implementor `%s` for collection-role `%s`", persisterClass.getName(), collectionBinding.getRole()), target);
        }
        catch (Exception e) {
            throw new MappingException("Could not instantiate collection persister " + persisterClass.getName(), e);
        }
    }

    private Constructor<? extends CollectionPersister> resolveCollectionPersisterConstructor(Class<? extends CollectionPersister> persisterClass) {
        try {
            return persisterClass.getConstructor(COLLECTION_PERSISTER_CONSTRUCTOR_ARGS);
        }
        catch (NoSuchMethodException noConstructorException) {
            try {
                Constructor<? extends CollectionPersister> constructor = persisterClass.getConstructor(LEGACY_COLLECTION_PERSISTER_CONSTRUCTOR_ARGS);
                DeprecationLogger.DEPRECATION_LOGGER.debugf("CollectionPersister implementation defined constructor using legacy signature using `%s`; use `%s` instead", PersisterCreationContext.class.getName(), RuntimeModelCreationContext.class.getName());
                return constructor;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new MappingException("Could not find appropriate constructor for " + persisterClass.getName(), noConstructorException);
            }
        }
    }

    @Override
    public EntityPersister createEntityPersister(PersistentClass entityBinding, EntityDataAccess entityCacheAccessStrategy, NaturalIdDataAccess naturalIdCacheAccessStrategy, PersisterCreationContext creationContext) {
        DeprecationLogger.DEPRECATION_LOGGER.debugf("Encountered use of deprecated `PersisterFactory#createEntityPersister` form accepting `%s`; use form accepting `%s` instead", PersisterCreationContext.class.getName(), RuntimeModelCreationContext.class.getName());
        return this.createEntityPersister(entityBinding, entityCacheAccessStrategy, naturalIdCacheAccessStrategy, (RuntimeModelCreationContext)creationContext);
    }

    @Override
    public CollectionPersister createCollectionPersister(Collection collectionBinding, CollectionDataAccess cacheAccessStrategy, PersisterCreationContext creationContext) throws HibernateException {
        DeprecationLogger.DEPRECATION_LOGGER.debugf("Encountered use of deprecated `PersisterFactory#createCollectionPersister` form accepting `%s`; use form accepting `%s` instead", PersisterCreationContext.class.getName(), RuntimeModelCreationContext.class.getName());
        return this.createCollectionPersister(collectionBinding, cacheAccessStrategy, (RuntimeModelCreationContext)creationContext);
    }
}

