/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.complete;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultBuilderInstantiationValued;
import org.hibernate.query.results.complete.CompleteResultBuilder;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.sqm.DynamicInstantiationNature;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.instantiation.internal.ArgumentDomainResult;
import org.hibernate.sql.results.graph.instantiation.internal.DynamicInstantiationResultImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.descriptor.java.JavaType;

public class CompleteResultBuilderInstantiation
implements CompleteResultBuilder,
ResultBuilderInstantiationValued {
    private final JavaType<?> javaType;
    private final List<ResultBuilder> argumentResultBuilders;

    public CompleteResultBuilderInstantiation(JavaType<?> javaType, List<ResultBuilder> argumentResultBuilders) {
        this.javaType = javaType;
        this.argumentResultBuilders = argumentResultBuilders;
    }

    @Override
    public Class<?> getJavaType() {
        return this.javaType.getJavaTypeClass();
    }

    @Override
    public ResultBuilder cacheKeyInstance() {
        return this;
    }

    @Override
    public DomainResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        ArrayList argumentDomainResults = new ArrayList(this.argumentResultBuilders.size());
        for (int i = 0; i < this.argumentResultBuilders.size(); ++i) {
            ResultBuilder argumentResultBuilder = this.argumentResultBuilders.get(i);
            ArgumentDomainResult argumentDomainResult = new ArgumentDomainResult(argumentResultBuilder.buildResult(jdbcResultsMetadata, i, legacyFetchResolver, domainResultCreationState));
            argumentDomainResults.add(argumentDomainResult);
        }
        return new DynamicInstantiationResultImpl(null, DynamicInstantiationNature.CLASS, this.javaType, argumentDomainResults);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompleteResultBuilderInstantiation that = (CompleteResultBuilderInstantiation)o;
        return this.javaType.equals(that.javaType) && this.argumentResultBuilders.equals(that.argumentResultBuilders);
    }

    public int hashCode() {
        int result = this.javaType.hashCode();
        result = 31 * result + this.argumentResultBuilders.hashCode();
        return result;
    }
}

