/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import jakarta.persistence.TupleElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public final class TupleMetadata {
    private final TupleElement<?>[] elements;
    private final String[] aliases;
    private Map<String, Integer> nameIndex;
    private Map<TupleElement<?>, Integer> elementIndex;
    private List<TupleElement<?>> list;

    public TupleMetadata(TupleElement<?>[] elements, String[] aliases) {
        this.elements = elements;
        this.aliases = aliases;
    }

    public Integer get(TupleElement<?> element) {
        if (this.elementIndex == null) {
            IdentityHashMap map = new IdentityHashMap(this.elements.length);
            for (int i = 0; i < this.elements.length; ++i) {
                map.put(this.elements[i], i);
            }
            this.elementIndex = Collections.unmodifiableMap(map);
        }
        return this.elementIndex.get(element);
    }

    public Integer get(String name) {
        if (this.nameIndex == null) {
            HashMap<String, Integer> map = new HashMap<String, Integer>(this.aliases.length);
            for (int i = 0; i < this.aliases.length; ++i) {
                map.put(this.aliases[i], i);
            }
            this.nameIndex = Collections.unmodifiableMap(map);
        }
        return this.nameIndex.get(name);
    }

    public List<TupleElement<?>> getList() {
        if (this.list == null) {
            this.list = List.of(this.elements);
        }
        return this.list;
    }
}

