/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.suspend;

import com.arjuna.ats.jbossatx.jta.RecoveryManagerService;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.ServerActivityCallback;

public class RecoverySuspendController
implements ServerActivity,
PropertyChangeListener {
    private final RecoveryManagerService recoveryManagerService;
    private boolean suspended;
    private boolean running;

    public RecoverySuspendController(RecoveryManagerService recoveryManagerService) {
        this.recoveryManagerService = recoveryManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSuspend(ServerActivityCallback serverActivityCallback) {
        RecoverySuspendController recoverySuspendController = this;
        synchronized (recoverySuspendController) {
            this.suspended = true;
        }
        this.recoveryManagerService.suspend();
        serverActivityCallback.done();
    }

    public void suspended(ServerActivityCallback serverActivityCallback) {
        serverActivityCallback.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        boolean doResume;
        RecoverySuspendController recoverySuspendController = this;
        synchronized (recoverySuspendController) {
            this.suspended = false;
            doResume = this.running;
        }
        if (doResume) {
            this.resumeRecovery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean doResume;
        RecoverySuspendController recoverySuspendController = this;
        synchronized (recoverySuspendController) {
            ControlledProcessState.State newState = (ControlledProcessState.State)evt.getNewValue();
            this.running = newState.isRunning();
            doResume = this.running && !this.suspended;
        }
        if (doResume) {
            this.resumeRecovery();
        }
    }

    private void resumeRecovery() {
        this.recoveryManagerService.resume();
    }
}

