/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.proton.ProtonClientOptions;
import java.util.Base64;
import java.util.Map;

public class ProtonClientOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, ProtonClientOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "enabledSaslMechanisms": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addEnabledSaslMechanism((String)item);
                        }
                    });
                    break;
                }
                case "heartbeat": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHeartbeat(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxFrameSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxFrameSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "sniServerName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSniServerName((String)member.getValue());
                    break;
                }
                case "virtualHost": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setVirtualHost((String)member.getValue());
                }
            }
        }
    }

    static void toJson(ProtonClientOptions obj, JsonObject json) {
        ProtonClientOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(ProtonClientOptions obj, Map<String, Object> json) {
        if (obj.getEnabledSaslMechanisms() != null) {
            JsonArray array = new JsonArray();
            obj.getEnabledSaslMechanisms().forEach(item -> array.add(item));
            json.put("enabledSaslMechanisms", array);
        }
        json.put("heartbeat", obj.getHeartbeat());
        json.put("maxFrameSize", obj.getMaxFrameSize());
        if (obj.getSniServerName() != null) {
            json.put("sniServerName", obj.getSniServerName());
        }
        if (obj.getVirtualHost() != null) {
            json.put("virtualHost", obj.getVirtualHost());
        }
    }
}

