/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.SecurityUtils;
import org.wildfly.common.Assert;

public interface DeploymentNodeSelector {
    public static final DeploymentNodeSelector FIRST = (eligibleNodes, appName, moduleName, distinctName) -> eligibleNodes[0];
    public static final DeploymentNodeSelector RANDOM = (eligibleNodes, appName, moduleName, distinctName) -> eligibleNodes[ThreadLocalRandom.current().nextInt(eligibleNodes.length)];
    public static final DeploymentNodeSelector ROUND_ROBIN = new DeploymentNodeSelector(){
        private final AtomicInteger counter = new AtomicInteger();

        @Override
        public String selectNode(String[] eligibleNodes, String appName, String moduleName, String distinctName) {
            int length = eligibleNodes.length;
            assert (length > 0);
            if (Logs.MAIN.isTraceEnabled()) {
                Logs.MAIN.tracef("ROUND_ROBIN [nodes=%s appName=%s moduleName=%s, distinctName=%s]", new Object[]{Arrays.deepToString(eligibleNodes), appName, moduleName, distinctName});
            }
            String node = eligibleNodes[Math.floorMod(this.counter.getAndIncrement(), length)];
            if (Logs.MAIN.isDebugEnabled()) {
                Logs.MAIN.debugf("ROUND_ROBIN select node %s for [app: %s, module: %s,  distinctname: %s]", new Object[]{node, appName, moduleName, distinctName});
            }
            return node;
        }
    };
    public static final DeploymentNodeSelector RANDOM_PREFER_LOCAL = new DeploymentNodeSelector(){
        private final String localNodeName = SecurityUtils.getString("jboss.node.name");

        @Override
        public String selectNode(String[] eligibleNodes, String appName, String moduleName, String distinctName) {
            if (Logs.MAIN.isTraceEnabled()) {
                Logs.MAIN.tracef("RANDOM_PREFER_LOCAL (%s) [nodes=%s appName=%s moduleName=%s, distinctName=%s]", new Object[]{this.localNodeName, Arrays.deepToString(eligibleNodes), appName, moduleName, distinctName});
            }
            if (eligibleNodes.length == 1) {
                return eligibleNodes[0];
            }
            if (this.localNodeName != null) {
                for (String eligibleNode : eligibleNodes) {
                    if (!this.localNodeName.equals(eligibleNode)) continue;
                    if (Logs.MAIN.isDebugEnabled()) {
                        Logs.MAIN.debugf("RANDOM_PREFER_LOCAL select local node %s for [app: %s, module: %s,  distinctname: %s]", new Object[]{eligibleNode, appName, moduleName, distinctName});
                    }
                    return eligibleNode;
                }
            }
            if (Logs.MAIN.isDebugEnabled()) {
                Logs.MAIN.debug("RANDOM_PREFER_LOCAL local node not avaialble, fallback to RANDOM selection");
            }
            return RANDOM.selectNode(eligibleNodes, appName, moduleName, distinctName);
        }
    };

    public String selectNode(String[] var1, String var2, String var3, String var4);

    @Deprecated
    public static DeploymentNodeSelector favorite(Collection<String> favorites, DeploymentNodeSelector fallback) {
        Assert.checkNotNullParam((String)"favorites", favorites);
        Assert.checkNotNullParam((String)"fallback", (Object)fallback);
        return (eligibleNodes, appName, moduleName, distinctName) -> {
            HashSet set = new HashSet(eligibleNodes.length);
            Collections.addAll(set, eligibleNodes);
            for (String favorite : favorites) {
                if (!set.contains(favorite)) continue;
                if (Logs.MAIN.isDebugEnabled()) {
                    Logs.MAIN.debugf("FAVORITE node %s for [app: %s, module: %s,  distinctname: %s]", new Object[]{favorite, appName, moduleName, distinctName});
                }
                return favorite;
            }
            if (Logs.MAIN.isDebugEnabled()) {
                Logs.MAIN.debugf("FAVORITE no favorite found use fallback for [eligibleNodes %s, app: %s, module: %s,  distinctname: %s]", new Object[]{Arrays.deepToString(eligibleNodes), appName, moduleName, distinctName});
            }
            return fallback.selectNode(eligibleNodes, appName, moduleName, distinctName);
        };
    }
}

