/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.ql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class PropertyPath<TypeDescriptor> {
    private final LinkedList<PropertyReference<TypeDescriptor>> nodes;
    private List<PropertyReference<TypeDescriptor>> unmodifiableNodes;
    private String asStringPath;
    private String asStringPathWithoutAlias;
    private String[] asArrayPath;

    public PropertyPath() {
        this.nodes = new LinkedList();
    }

    public PropertyPath(List<PropertyReference<TypeDescriptor>> nodes) {
        this.nodes = new LinkedList<PropertyReference<TypeDescriptor>>(nodes);
    }

    public boolean isAlias() {
        return this.getFirst().isAlias();
    }

    public PropertyReference<TypeDescriptor> getFirst() {
        return this.nodes.getFirst();
    }

    public PropertyReference<TypeDescriptor> getLast() {
        return this.nodes.getLast();
    }

    public List<PropertyReference<TypeDescriptor>> getNodes() {
        if (this.unmodifiableNodes == null) {
            this.unmodifiableNodes = Collections.unmodifiableList(this.nodes);
        }
        return this.unmodifiableNodes;
    }

    public void append(PropertyReference<TypeDescriptor> propertyReference) {
        this.nodes.add(propertyReference);
        this.asArrayPath = null;
        this.asStringPath = null;
        this.asStringPathWithoutAlias = null;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public int getLength() {
        return this.nodes.size();
    }

    public String asStringPath() {
        if (this.asStringPath == null) {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (PropertyReference propertyReference : this.nodes) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append('.');
                }
                sb.append(propertyReference.getPropertyName());
            }
            this.asStringPath = sb.toString();
        }
        return this.asStringPath;
    }

    public String asStringPathWithoutAlias() {
        if (this.asStringPathWithoutAlias == null) {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (PropertyReference propertyReference : this.nodes) {
                if (propertyReference.isAlias()) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append('.');
                }
                sb.append(propertyReference.getPropertyName());
            }
            this.asStringPathWithoutAlias = sb.toString();
        }
        return this.asStringPathWithoutAlias;
    }

    public String[] asArrayPath() {
        if (this.asArrayPath == null) {
            String[] arrayPath = new String[this.nodes.size()];
            int i = 0;
            for (PropertyReference propertyReference : this.nodes) {
                arrayPath[i++] = propertyReference.getPropertyName();
            }
            this.asArrayPath = arrayPath;
        }
        return this.asArrayPath;
    }

    public List<String> getNodeNamesWithoutAlias() {
        ArrayList<String> list = new ArrayList<String>(this.nodes.size());
        for (PropertyReference propertyReference : this.nodes) {
            if (propertyReference.isAlias()) continue;
            list.add(propertyReference.getPropertyName());
        }
        return list;
    }

    public List<PropertyReference<TypeDescriptor>> getNodesWithoutAlias() {
        ArrayList<PropertyReference<TypeDescriptor>> list = new ArrayList<PropertyReference<TypeDescriptor>>(this.nodes.size());
        for (PropertyReference propertyReference : this.nodes) {
            if (propertyReference.isAlias()) continue;
            list.add(propertyReference);
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        PropertyPath that = (PropertyPath)o;
        return this.nodes.equals(that.nodes);
    }

    public int hashCode() {
        return this.nodes.hashCode();
    }

    public String toString() {
        return this.asStringPath();
    }

    public static <TypeDescriptor> PropertyPath<TypeDescriptor> make(String propertyPath) {
        String[] splinters = propertyPath.split("[.]");
        ArrayList<PropertyReference<TypeDescriptor>> nodes = new ArrayList<PropertyReference<TypeDescriptor>>(splinters.length);
        for (String name : splinters) {
            nodes.add(new PropertyReference<Object>(name, null, false));
        }
        return new PropertyPath<TypeDescriptor>(nodes);
    }

    public static final class PropertyReference<TypeDescriptor> {
        private final String propertyName;
        private final TypeDescriptor typeDescriptor;
        private final boolean isAlias;

        public PropertyReference(String propertyName, TypeDescriptor typeDescriptor, boolean isAlias) {
            this.propertyName = propertyName;
            this.typeDescriptor = typeDescriptor;
            this.isAlias = isAlias;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public boolean isAlias() {
            return this.isAlias;
        }

        public TypeDescriptor getTypeDescriptor() {
            return this.typeDescriptor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            PropertyReference that = (PropertyReference)o;
            return this.isAlias == that.isAlias && this.propertyName.equals(that.propertyName) && (this.typeDescriptor != null ? this.typeDescriptor.equals(that.typeDescriptor) : that.typeDescriptor == null);
        }

        public int hashCode() {
            int result = this.propertyName.hashCode();
            result = 31 * result + (this.isAlias ? 1 : 0);
            result = 31 * result + (this.typeDescriptor != null ? this.typeDescriptor.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.propertyName;
        }
    }
}

