/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.ql;

import org.infinispan.objectfilter.ParsingException;
import org.infinispan.objectfilter.impl.antlr.runtime.ANTLRStringStream;
import org.infinispan.objectfilter.impl.antlr.runtime.CommonTokenStream;
import org.infinispan.objectfilter.impl.antlr.runtime.RecognitionException;
import org.infinispan.objectfilter.impl.antlr.runtime.TokenStream;
import org.infinispan.objectfilter.impl.antlr.runtime.tree.CommonTree;
import org.infinispan.objectfilter.impl.antlr.runtime.tree.CommonTreeNodeStream;
import org.infinispan.objectfilter.impl.antlr.runtime.tree.TreeNodeStream;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.ql.QueryRendererDelegate;
import org.infinispan.objectfilter.impl.ql.QueryResolverDelegate;
import org.infinispan.objectfilter.impl.ql.parse.IckleLexer;
import org.infinispan.objectfilter.impl.ql.parse.IckleParser;
import org.infinispan.objectfilter.impl.ql.parse.QueryRenderer;
import org.infinispan.objectfilter.impl.ql.parse.QueryResolver;
import org.jboss.logging.Logger;

public final class QueryParser {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)QueryParser.class.getName());

    public CommonTree parseQuery(String queryString, QueryResolverDelegate<?> resolverDelegate, QueryRendererDelegate<?> rendererDelegate) throws ParsingException {
        IckleLexer lexer = new IckleLexer(new ANTLRStringStream(queryString));
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        IckleParser parser = new IckleParser(tokens);
        try {
            IckleParser.statement_return r = parser.statement();
            if (parser.hasErrors()) {
                throw log.getQuerySyntaxException(queryString, parser.getErrorMessages());
            }
            CommonTree tree = (CommonTree)r.getTree();
            tree = this.resolve(tokens, tree, resolverDelegate);
            tree = this.render(tokens, tree, rendererDelegate);
            return tree;
        }
        catch (RecognitionException e) {
            throw log.getQuerySyntaxException(queryString, e);
        }
    }

    private CommonTree resolve(TokenStream tokens, CommonTree tree, QueryResolverDelegate<?> resolverDelegate) throws RecognitionException {
        CommonTreeNodeStream treeNodeStream = new CommonTreeNodeStream(tree);
        treeNodeStream.setTokenStream(tokens);
        return new QueryResolver((TreeNodeStream)treeNodeStream, resolverDelegate).statement().getTree();
    }

    private CommonTree render(TokenStream tokens, CommonTree tree, QueryRendererDelegate<?> rendererDelegate) throws RecognitionException {
        CommonTreeNodeStream treeNodeStream = new CommonTreeNodeStream(tree);
        treeNodeStream.setTokenStream(tokens);
        return new QueryRenderer((TreeNodeStream)treeNodeStream, rendererDelegate).statement().getTree();
    }
}

