/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.antlr.runtime.tree.Tree;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.ql.AggregationFunction;
import org.infinispan.objectfilter.impl.ql.JoinType;
import org.infinispan.objectfilter.impl.ql.PropertyPath;
import org.infinispan.objectfilter.impl.ql.QueryRendererDelegate;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.IndexedFieldProvider;
import org.infinispan.objectfilter.impl.syntax.parser.AggregationPropertyPath;
import org.infinispan.objectfilter.impl.syntax.parser.CacheValueAggregationPropertyPath;
import org.infinispan.objectfilter.impl.syntax.parser.ExpressionBuilder;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.objectfilter.impl.syntax.parser.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.syntax.parser.TypeDescriptor;
import org.infinispan.objectfilter.impl.syntax.parser.projection.CacheValuePropertyPath;
import org.infinispan.objectfilter.impl.syntax.parser.projection.VersionPropertyPath;
import org.jboss.logging.Logger;

final class QueryRendererDelegateImpl<TypeMetadata>
implements QueryRendererDelegate<TypeDescriptor<TypeMetadata>> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)QueryRendererDelegateImpl.class.getName());
    private static final int ARRAY_INITIAL_LENGTH = 5;
    private Phase phase;
    private IckleParsingResult.StatementType statementType;
    private String targetTypeName;
    private TypeMetadata targetEntityMetadata;
    private IndexedFieldProvider.FieldIndexingMetadata fieldIndexingMetadata;
    private PropertyPath<TypeDescriptor<TypeMetadata>> propertyPath;
    private AggregationFunction aggregationFunction;
    private final ExpressionBuilder<TypeMetadata> whereBuilder;
    private final ExpressionBuilder<TypeMetadata> havingBuilder;
    private final Map<String, String> aliasToEntityType = new HashMap<String, String>();
    private final Map<String, PropertyPath<TypeDescriptor<TypeMetadata>>> aliasToPropertyPath = new HashMap<String, PropertyPath<TypeDescriptor<TypeMetadata>>>();
    private String alias;
    private final Map<String, Object> namedParameters = new HashMap<String, Object>(5);
    private final ObjectPropertyHelper<TypeMetadata> propertyHelper;
    private List<PropertyPath<TypeDescriptor<TypeMetadata>>> groupBy;
    private List<SortField> sortFields;
    private List<PropertyPath<TypeDescriptor<TypeMetadata>>> projections;
    private List<Class<?>> projectedTypes;
    private List<Object> projectedNullMarkers;
    private final String queryString;
    private boolean asteriskCount = false;

    QueryRendererDelegateImpl(String queryString, ObjectPropertyHelper<TypeMetadata> propertyHelper) {
        this.queryString = queryString;
        this.propertyHelper = propertyHelper;
        this.whereBuilder = new ExpressionBuilder<TypeMetadata>(propertyHelper);
        this.havingBuilder = new ExpressionBuilder<TypeMetadata>(propertyHelper);
    }

    @Override
    public void registerPersisterSpace(String entityName, Tree aliasTree) {
        String aliasText = aliasTree.getText();
        String previous = this.aliasToEntityType.put(aliasText, entityName);
        if (previous != null && !previous.equalsIgnoreCase(entityName)) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + aliasText + " already assigned to type " + previous);
        }
        if (this.targetTypeName != null) {
            throw new IllegalStateException("Can't target multiple types: " + this.targetTypeName + " already selected before " + entityName);
        }
        this.targetTypeName = entityName;
        this.targetEntityMetadata = this.propertyHelper.getEntityMetadata(this.targetTypeName);
        if (this.targetEntityMetadata == null) {
            throw log.getUnknownEntity(this.targetTypeName);
        }
        this.fieldIndexingMetadata = this.propertyHelper.getIndexedFieldProvider().get(this.targetEntityMetadata);
        this.whereBuilder.setEntityType(this.targetEntityMetadata);
        this.havingBuilder.setEntityType(this.targetEntityMetadata);
    }

    public void registerEmbeddedAlias(String aliasText, PropertyPath<TypeDescriptor<TypeMetadata>> propertyPath) {
        PropertyPath<TypeDescriptor<TypeMetadata>> previous = this.aliasToPropertyPath.put(aliasText, propertyPath);
        if (previous != null) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + aliasText + " already assigned to type " + String.valueOf(previous));
        }
    }

    @Override
    public boolean isUnqualifiedPropertyReference() {
        return true;
    }

    @Override
    public boolean isPersisterReferenceAlias() {
        return this.aliasToEntityType.containsKey(this.alias);
    }

    @Override
    public void activateFromStrategy(JoinType joinType, Tree associationFetchTree, Tree propertyFetchTree, Tree alias) {
        this.phase = Phase.FROM;
        this.alias = alias.getText();
    }

    @Override
    public void activateSelectStrategy() {
        this.phase = Phase.SELECT;
        this.statementType = IckleParsingResult.StatementType.SELECT;
    }

    @Override
    public void activateDeleteStrategy() {
        this.phase = Phase.SELECT;
        this.statementType = IckleParsingResult.StatementType.DELETE;
    }

    @Override
    public void activateWhereStrategy() {
        this.phase = Phase.WHERE;
    }

    @Override
    public void activateGroupByStrategy() {
        this.phase = Phase.GROUP_BY;
    }

    @Override
    public void activateHavingStrategy() {
        this.phase = Phase.HAVING;
    }

    @Override
    public void activateOrderByStrategy() {
        this.phase = Phase.ORDER_BY;
    }

    @Override
    public void deactivateStrategy() {
        this.phase = null;
        this.alias = null;
        this.propertyPath = null;
        this.aggregationFunction = null;
    }

    @Override
    public void activateOR() {
        if (this.phase == Phase.WHERE) {
            this.whereBuilder.pushOr();
        } else if (this.phase == Phase.HAVING) {
            this.havingBuilder.pushOr();
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void activateAND() {
        if (this.phase == Phase.WHERE) {
            this.whereBuilder.pushAnd();
        } else if (this.phase == Phase.HAVING) {
            this.havingBuilder.pushAnd();
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void activateNOT() {
        if (this.phase == Phase.WHERE) {
            this.whereBuilder.pushNot();
        } else if (this.phase == Phase.HAVING) {
            this.havingBuilder.pushNot();
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void predicateLess(String value) {
        this.addComparisonPredicate(value, ComparisonExpr.Type.LESS);
    }

    @Override
    public void predicateLessOrEqual(String value) {
        this.addComparisonPredicate(value, ComparisonExpr.Type.LESS_OR_EQUAL);
    }

    @Override
    public void predicateEquals(String value) {
        this.addComparisonPredicate(value, ComparisonExpr.Type.EQUAL);
    }

    @Override
    public void predicateNotEquals(String value) {
        this.activateNOT();
        this.addComparisonPredicate(value, ComparisonExpr.Type.EQUAL);
        this.deactivateBoolean();
    }

    @Override
    public void predicateGreaterOrEqual(String value) {
        this.addComparisonPredicate(value, ComparisonExpr.Type.GREATER_OR_EQUAL);
    }

    @Override
    public void predicateGreater(String value) {
        this.addComparisonPredicate(value, ComparisonExpr.Type.GREATER);
    }

    private void addComparisonPredicate(String value, ComparisonExpr.Type comparisonType) {
        this.ensureLeftSideIsAPropertyPath();
        PropertyPath<TypeDescriptor<TypeMetadata>> property = this.resolveAlias(this.propertyPath);
        if (property.isEmpty()) {
            throw log.getPredicatesOnEntityAliasNotAllowedException(this.propertyPath.asStringPath());
        }
        Object comparisonValue = this.parameterValue(value);
        this.checkAnalyzed(property, false);
        if (this.phase == Phase.WHERE) {
            this.whereBuilder.addComparison(property, comparisonType, comparisonValue);
        } else if (this.phase == Phase.HAVING) {
            this.havingBuilder.addComparison(property, comparisonType, comparisonValue);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void predicateIn(List<String> list) {
        this.ensureLeftSideIsAPropertyPath();
        ArrayList<Object> values = new ArrayList<Object>(list.size());
        for (String string : list) {
            values.add(this.parameterValue(string));
        }
        PropertyPath<TypeDescriptor<TypeMetadata>> property = this.resolveAlias(this.propertyPath);
        if (property.isEmpty()) {
            throw log.getPredicatesOnEntityAliasNotAllowedException(this.propertyPath.asStringPath());
        }
        if (this.phase == Phase.WHERE) {
            this.whereBuilder.addIn(property, values);
        } else if (this.phase == Phase.HAVING) {
            this.havingBuilder.addIn(property, values);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void predicateBetween(String lowerValue, String upperValue) {
        this.ensureLeftSideIsAPropertyPath();
        Object lowerComparisonValue = this.parameterValue(lowerValue);
        Object upperComparisonValue = this.parameterValue(upperValue);
        PropertyPath<TypeDescriptor<TypeMetadata>> property = this.resolveAlias(this.propertyPath);
        if (property.isEmpty()) {
            throw log.getPredicatesOnEntityAliasNotAllowedException(this.propertyPath.asStringPath());
        }
        this.checkAnalyzed(property, false);
        if (this.phase == Phase.WHERE) {
            this.whereBuilder.addRange(property, lowerComparisonValue, upperComparisonValue);
        } else if (this.phase == Phase.HAVING) {
            this.havingBuilder.addRange(property, lowerComparisonValue, upperComparisonValue);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void predicateLike(String patternValue, Character escapeCharacter) {
        this.ensureLeftSideIsAPropertyPath();
        Object pattern = this.parameterValue(patternValue);
        PropertyPath<TypeDescriptor<TypeMetadata>> property = this.resolveAlias(this.propertyPath);
        if (property.isEmpty()) {
            throw log.getPredicatesOnEntityAliasNotAllowedException(this.propertyPath.asStringPath());
        }
        this.checkAnalyzed(property, false);
        if (this.phase == Phase.WHERE) {
            this.whereBuilder.addLike(property, pattern, escapeCharacter);
        } else if (this.phase == Phase.HAVING) {
            this.havingBuilder.addLike(property, pattern, escapeCharacter);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void predicateIsNull() {
        this.ensureLeftSideIsAPropertyPath();
        PropertyPath<TypeDescriptor<TypeMetadata>> property = this.resolveAlias(this.propertyPath);
        if (property.isEmpty()) {
            throw log.getPredicatesOnEntityAliasNotAllowedException(this.propertyPath.asStringPath());
        }
        this.checkAnalyzed(property, false);
        if (this.phase == Phase.WHERE) {
            this.whereBuilder.addIsNull(property);
        } else if (this.phase == Phase.HAVING) {
            this.havingBuilder.addIsNull(property);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void predicateConstantBoolean(boolean booleanConstant) {
        if (this.phase == Phase.WHERE) {
            this.whereBuilder.addConstantBoolean(booleanConstant);
        } else if (this.phase == Phase.HAVING) {
            this.havingBuilder.addConstantBoolean(booleanConstant);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void predicateFullTextTerm(String term, String fuzzyFlop) {
        this.ensureLeftSideIsAPropertyPath();
        PropertyPath<TypeDescriptor<TypeMetadata>> property = this.resolveAlias(this.propertyPath);
        if (property.isEmpty()) {
            throw log.getPredicatesOnEntityAliasNotAllowedException(this.propertyPath.asStringPath());
        }
        if (this.phase != Phase.WHERE) {
            if (this.phase == Phase.HAVING) {
                throw log.getFullTextQueriesNotAllowedInHavingClauseException();
            }
            throw new IllegalStateException();
        }
        this.checkAnalyzed(property, true);
        Object comparisonObject = this.parameterValue(term);
        this.whereBuilder.addFullTextTerm(property, comparisonObject, fuzzyFlop == null ? null : Integer.valueOf(fuzzyFlop.equals("~") ? 2 : Integer.parseInt(fuzzyFlop)));
    }

    @Override
    public void predicateFullTextRegexp(String term) {
        this.ensureLeftSideIsAPropertyPath();
        PropertyPath<TypeDescriptor<TypeMetadata>> property = this.resolveAlias(this.propertyPath);
        if (property.isEmpty()) {
            throw log.getPredicatesOnEntityAliasNotAllowedException(this.propertyPath.asStringPath());
        }
        if (this.phase != Phase.WHERE) {
            if (this.phase == Phase.HAVING) {
                throw log.getFullTextQueriesNotAllowedInHavingClauseException();
            }
            throw new IllegalStateException();
        }
        this.checkAnalyzed(property, true);
        this.whereBuilder.addFullTextRegexp(property, term);
    }

    @Override
    public void predicateFullTextRange(boolean includeLower, String lower, String upper, boolean includeUpper) {
        PropertyPath<TypeDescriptor<TypeMetadata>> property;
        this.ensureLeftSideIsAPropertyPath();
        if (this.phase == Phase.WHERE) {
            property = this.resolveAlias(this.propertyPath);
            if (property.isEmpty()) {
                throw log.getPredicatesOnEntityAliasNotAllowedException(this.propertyPath.asStringPath());
            }
        } else {
            if (this.phase == Phase.HAVING) {
                throw log.getFullTextQueriesNotAllowedInHavingClauseException();
            }
            throw new IllegalStateException();
        }
        Object from = lower != null ? this.parameterValue(lower) : null;
        Object to = upper != null ? this.parameterValue(upper) : null;
        this.checkIndexed(property);
        this.whereBuilder.addFullTextRange(property, includeLower, from, to, includeUpper);
    }

    private void checkAnalyzed(PropertyPath<?> propertyPath, boolean expectAnalyzed) {
        if (!expectAnalyzed) {
            if (this.fieldIndexingMetadata.isAnalyzed(propertyPath.asArrayPath())) {
                throw log.getQueryOnAnalyzedPropertyNotSupportedException(this.targetTypeName, propertyPath.asStringPath());
            }
            return;
        }
        if (!this.fieldIndexingMetadata.isAnalyzed(propertyPath.asArrayPath()) && !this.fieldIndexingMetadata.isNormalized(propertyPath.asArrayPath())) {
            throw log.getFullTextQueryOnNotAalyzedPropertyNotSupportedException(this.targetTypeName, propertyPath.asStringPath());
        }
    }

    private void checkIndexed(PropertyPath<?> propertyPath) {
        if (!this.fieldIndexingMetadata.isSearchable(propertyPath.asArrayPath())) {
            throw log.getFullTextQueryOnNotIndexedPropertyNotSupportedException(this.targetTypeName, propertyPath.asStringPath());
        }
    }

    @Override
    public void activateFullTextBoost(float boost) {
        if (this.phase != Phase.WHERE) {
            if (this.phase == Phase.HAVING) {
                throw log.getFullTextQueriesNotAllowedInHavingClauseException();
            }
            throw new IllegalStateException();
        }
        this.whereBuilder.pushFullTextBoost(boost);
    }

    @Override
    public void deactivateFullTextBoost() {
        if (this.phase != Phase.WHERE) {
            if (this.phase == Phase.HAVING) {
                throw log.getFullTextQueriesNotAllowedInHavingClauseException();
            }
            throw new IllegalStateException();
        }
        this.whereBuilder.pop();
    }

    @Override
    public void activateFullTextOccur(QueryRendererDelegate.Occur occur) {
        if (this.phase != Phase.WHERE) {
            if (this.phase == Phase.HAVING) {
                throw log.getFullTextQueriesNotAllowedInHavingClauseException();
            }
            throw new IllegalStateException();
        }
        this.whereBuilder.pushFullTextOccur(occur);
    }

    @Override
    public void deactivateFullTextOccur() {
        if (this.phase != Phase.WHERE) {
            if (this.phase == Phase.HAVING) {
                throw log.getFullTextQueriesNotAllowedInHavingClauseException();
            }
            throw new IllegalStateException();
        }
        this.whereBuilder.pop();
    }

    @Override
    public void setPropertyPath(PropertyPath<TypeDescriptor<TypeMetadata>> propertyPath) {
        boolean aggregationPropertyPath = false;
        if (this.aggregationFunction != null) {
            if (propertyPath == null && this.aggregationFunction != AggregationFunction.COUNT && this.aggregationFunction != AggregationFunction.COUNT_DISTINCT) {
                throw log.getAggregationCanOnlyBeAppliedToPropertyReferencesException(this.aggregationFunction.name());
            }
            propertyPath = new AggregationPropertyPath<TypeMetadata>(this.aggregationFunction, propertyPath.getNodes());
            aggregationPropertyPath = true;
        }
        if (this.phase == Phase.SELECT) {
            Object nullMarker;
            Class<?> propertyType;
            PropertyPath projection;
            if (this.projections == null) {
                this.projections = new ArrayList<PropertyPath<TypeDescriptor<TypeMetadata>>>(5);
                this.projectedTypes = new ArrayList(5);
                this.projectedNullMarkers = new ArrayList<Object>(5);
            }
            if (propertyPath.getLength() == 1 && propertyPath.isAlias()) {
                projection = !aggregationPropertyPath ? new CacheValuePropertyPath<TypeDescriptor<TypeMetadata>>() : new CacheValueAggregationPropertyPath<TypeMetadata>();
                propertyType = null;
                nullMarker = null;
            } else {
                projection = this.resolveAlias(propertyPath);
                propertyType = this.propertyHelper.getPrimitivePropertyType(this.targetEntityMetadata, projection.asArrayPath());
                nullMarker = this.fieldIndexingMetadata.getNullMarker(projection.asArrayPath());
            }
            this.projections.add(projection);
            this.projectedTypes.add(propertyType);
            this.projectedNullMarkers.add(nullMarker);
        } else {
            this.propertyPath = propertyPath;
        }
    }

    @Override
    public void activateAggregation(AggregationFunction aggregationFunction) {
        if (this.phase == Phase.WHERE) {
            throw log.getNoAggregationsInWhereClauseException(aggregationFunction.name());
        }
        if (this.phase == Phase.GROUP_BY) {
            throw log.getNoAggregationsInGroupByClauseException(aggregationFunction.name());
        }
        this.aggregationFunction = aggregationFunction;
        this.propertyPath = null;
    }

    @Override
    public void activateAsteriskAggregation(AggregationFunction aggregationFunction) {
        this.activateAggregation(aggregationFunction);
        this.asteriskCount = true;
    }

    @Override
    public void deactivateAggregation() {
        this.aggregationFunction = null;
    }

    @Override
    public void projectVersion() {
        if (this.phase != Phase.SELECT) {
            return;
        }
        if (this.projections == null) {
            this.projections = new ArrayList<PropertyPath<TypeDescriptor<TypeMetadata>>>(5);
            this.projectedTypes = new ArrayList(5);
            this.projectedNullMarkers = new ArrayList<Object>(5);
        }
        this.projections.add(new VersionPropertyPath());
        this.projectedTypes.add(Object.class);
        this.projectedNullMarkers.add(null);
    }

    @Override
    public void sortSpecification(String collateName, boolean isAscending) {
        PropertyPath<TypeDescriptor<TypeMetadata>> property = this.resolveAlias(this.propertyPath);
        this.checkAnalyzed(property, false);
        if (this.sortFields == null) {
            this.sortFields = new ArrayList<SortField>(5);
        }
        this.sortFields.add(new IckleParsingResult.SortFieldImpl<TypeMetadata>(property, isAscending));
    }

    @Override
    public void groupingValue(String collateName) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<PropertyPath<TypeDescriptor<TypeMetadata>>>(5);
        }
        this.groupBy.add(this.resolveAlias(this.propertyPath));
        if (!this.asteriskCount) {
            return;
        }
        if (this.projections == null) {
            this.projections = new ArrayList<PropertyPath<TypeDescriptor<TypeMetadata>>>(5);
            this.projectedTypes = new ArrayList(5);
            this.projectedNullMarkers = new ArrayList<Object>(5);
        }
        this.projections.add(new CacheValueAggregationPropertyPath());
        this.projectedTypes.add(null);
        this.projectedNullMarkers.add(null);
        this.asteriskCount = false;
    }

    private Object parameterValue(String value) {
        PropertyPath<TypeDescriptor<TypeMetadata>> resolved;
        if (value.startsWith(":")) {
            String paramName = value.substring(1).trim();
            ConstantValueExpr.ParamPlaceholder namedParam = (ConstantValueExpr.ParamPlaceholder)this.namedParameters.get(paramName);
            if (namedParam == null) {
                namedParam = new ConstantValueExpr.ParamPlaceholder(paramName);
                this.namedParameters.put(paramName, namedParam);
            }
            return namedParam;
        }
        List<String> path = this.propertyPath.getNodeNamesWithoutAlias();
        PropertyPath<TypeDescriptor<TypeMetadata>> fullPath = this.propertyPath;
        while (fullPath.isAlias() && (resolved = this.aliasToPropertyPath.get(fullPath.getFirst().getPropertyName())) != null) {
            path.addAll(0, resolved.getNodeNamesWithoutAlias());
            fullPath = resolved;
        }
        return this.propertyHelper.convertToPropertyType(this.targetEntityMetadata, path.toArray(new String[path.size()]), value);
    }

    @Override
    public void deactivateBoolean() {
        if (this.phase == Phase.WHERE) {
            this.whereBuilder.pop();
        } else if (this.phase == Phase.HAVING) {
            this.havingBuilder.pop();
        } else {
            throw new IllegalStateException();
        }
    }

    private PropertyPath<TypeDescriptor<TypeMetadata>> resolveAlias(PropertyPath<TypeDescriptor<TypeMetadata>> path) {
        List resolved = this.resolveAliasPath(path);
        return path instanceof AggregationPropertyPath ? new AggregationPropertyPath(((AggregationPropertyPath)path).getAggregationFunction(), resolved) : new PropertyPath(resolved);
    }

    private List<PropertyPath.PropertyReference<TypeDescriptor<TypeMetadata>>> resolveAliasPath(PropertyPath<TypeDescriptor<TypeMetadata>> path) {
        if (path.isAlias()) {
            String alias = path.getFirst().getPropertyName();
            if (this.aliasToEntityType.containsKey(alias)) {
                return path.getNodesWithoutAlias();
            }
            if (this.aliasToPropertyPath.containsKey(alias)) {
                PropertyPath<TypeDescriptor<TypeMetadata>> propertyPath = this.aliasToPropertyPath.get(alias);
                List<PropertyPath.PropertyReference<TypeDescriptor<TypeMetadata>>> resolvedAlias = this.resolveAliasPath(propertyPath);
                resolvedAlias.addAll(path.getNodesWithoutAlias());
                return resolvedAlias;
            }
            throw log.getUnknownAliasException(alias);
        }
        return path.getNodesWithoutAlias();
    }

    @Override
    public void registerJoinAlias(Tree alias, PropertyPath<TypeDescriptor<TypeMetadata>> path) {
        if (!this.aliasToPropertyPath.containsKey(alias.getText())) {
            this.aliasToPropertyPath.put(alias.getText(), path);
        }
    }

    private void ensureLeftSideIsAPropertyPath() {
        if (this.propertyPath == null) {
            throw log.getLeftSideMustBeAPropertyPath();
        }
    }

    public IckleParsingResult<TypeMetadata> getResult() {
        return new IckleParsingResult<TypeMetadata>(this.queryString, this.statementType, Collections.unmodifiableSet(new HashSet<String>(this.namedParameters.keySet())), this.whereBuilder.build(), this.havingBuilder.build(), this.targetTypeName, this.targetEntityMetadata, this.projections == null ? null : this.projections.toArray(new PropertyPath[this.projections.size()]), this.projectedTypes == null ? null : this.projectedTypes.toArray(new Class[this.projectedTypes.size()]), this.projectedNullMarkers == null ? null : this.projectedNullMarkers.toArray(new Object[this.projectedNullMarkers.size()]), this.groupBy == null ? null : this.groupBy.toArray(new PropertyPath[this.groupBy.size()]), this.sortFields == null ? null : this.sortFields.toArray(new SortField[this.sortFields.size()]));
    }

    private static enum Phase {
        SELECT,
        FROM,
        WHERE,
        GROUP_BY,
        HAVING,
        ORDER_BY;

    }
}

