/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.function.Consumer;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.ServiceConfigurator;

public class ChannelClusterServiceConfigurator
extends CapabilityServiceNameProvider
implements ResourceServiceConfigurator {
    private final String name;
    private volatile String cluster;

    public ChannelClusterServiceConfigurator(PathAddress address) {
        super((Capability)ChannelResourceDefinition.Capability.JCHANNEL_CLUSTER, address);
        this.name = address.getLastElement().getValue();
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.cluster = ChannelResourceDefinition.Attribute.CLUSTER.resolveModelAttribute((ExpressionResolver)context, model).asString(this.name);
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer cluster = builder.provides(new ServiceName[]{this.getServiceName()});
        Service service = Service.newInstance((Consumer)cluster, (Object)this.cluster);
        return builder.setInstance(service);
    }
}

