/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr.cli;

import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.core.instmgr.cli.AbstractInstMgrCommand;
import org.wildfly.core.instmgr.cli.InstMgrActivator;

@CommandDefinition(name="channel-remove", description="Unsubscribe the installation from a channel.", activator=InstMgrActivator.class)
public class ChannelRemoveCommand
extends AbstractInstMgrCommand {
    @Option(name="channel-name", required=true)
    String channelName;

    @Override
    protected Operation buildOperation() {
        ModelNode op = new ModelNode();
        op.get("operation").set("channel-remove");
        op.get("name").set(this.channelName);
        return OperationBuilder.create((ModelNode)op).build();
    }

    @Override
    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        CommandContext ctx = commandInvocation.getCommandContext();
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            ctx.printLine("You are disconnected at the moment. Type 'connect' to connect to the server or 'help' for the list of supported commands.");
            return CommandResult.FAILURE;
        }
        this.executeOp(ctx, this.host);
        ctx.printLine(String.format("Channel '%s' has been successfully removed.", this.channelName));
        return CommandResult.SUCCESS;
    }
}

