/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr.cli;

import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.core.instmgr.InstMgrCustomPatchRemoveHandler;
import org.wildfly.core.instmgr.cli.AbstractInstMgrCommand;
import org.wildfly.core.instmgr.cli.InstMgrActivator;

@CommandDefinition(name="remove-custom-patch", description="Removes a custom patch and its channel from the server.", activator=InstMgrActivator.class)
public class CustomPatchRemoveCommand
extends AbstractInstMgrCommand {
    @Option(name="manifest", required=true)
    private String manifestGA;

    @Override
    protected Operation buildOperation() throws CommandException {
        ModelNode op = new ModelNode();
        OperationBuilder operationBuilder = OperationBuilder.create((ModelNode)op);
        op.get("operation").set(InstMgrCustomPatchRemoveHandler.DEFINITION.getName());
        op.get("manifest").set(this.manifestGA);
        return operationBuilder.build();
    }

    @Override
    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        CommandContext ctx = commandInvocation.getCommandContext();
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            ctx.printLine("You are disconnected at the moment. Type 'connect' to connect to the server or 'help' for the list of supported commands.");
            return CommandResult.FAILURE;
        }
        this.executeOp(ctx, this.host);
        ctx.printLine("Custom Patch successfully removed");
        return CommandResult.SUCCESS;
    }
}

