/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage_V2;

public class ClusterTopologyChangeMessage_V3
extends ClusterTopologyChangeMessage_V2 {
    private String scaleDownGroupName;

    public ClusterTopologyChangeMessage_V3(long uniqueEventID, String nodeID, String backupGroupName, String scaleDownGroupName, Pair<TransportConfiguration, TransportConfiguration> pair, boolean last) {
        this(122, uniqueEventID, nodeID, backupGroupName, scaleDownGroupName, pair, last);
    }

    protected ClusterTopologyChangeMessage_V3(byte type, long uniqueEventID, String nodeID, String backupGroupName, String scaleDownGroupName, Pair<TransportConfiguration, TransportConfiguration> pair, boolean last) {
        super(type);
        this.nodeID = nodeID;
        this.pair = pair;
        this.last = last;
        this.exit = false;
        this.uniqueEventID = uniqueEventID;
        this.backupGroupName = backupGroupName;
        this.scaleDownGroupName = scaleDownGroupName;
    }

    public ClusterTopologyChangeMessage_V3() {
        super((byte)122);
    }

    public ClusterTopologyChangeMessage_V3(byte type) {
        super(type);
    }

    public String getScaleDownGroupName() {
        return this.scaleDownGroupName;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeNullableString(this.scaleDownGroupName);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.scaleDownGroupName = buffer.readNullableString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.scaleDownGroupName == null ? 0 : this.scaleDownGroupName.hashCode());
        return result;
    }

    @Override
    protected String getPacketString() {
        StringBuffer buff = new StringBuffer(super.getPacketString());
        buff.append(", exit=" + this.exit);
        buff.append(", last=" + this.last);
        buff.append(", nodeID=" + this.nodeID);
        buff.append(", pair=" + this.pair);
        buff.append(", backupGroupName=" + this.backupGroupName);
        buff.append(", uniqueEventID=" + this.uniqueEventID);
        buff.append(", scaleDownGroupName=" + this.scaleDownGroupName);
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ClusterTopologyChangeMessage_V3)) {
            return false;
        }
        ClusterTopologyChangeMessage_V3 other = (ClusterTopologyChangeMessage_V3)obj;
        return !(this.scaleDownGroupName == null ? other.scaleDownGroupName != null : !this.scaleDownGroupName.equals(other.scaleDownGroupName));
    }
}

