/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.ssl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.activemq.artemis.core.remoting.impl.ssl.SSLSupport;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextConfig;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextFactory;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSSLContextFactory
implements SSLContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public SSLContext getSSLContext(SSLContextConfig config, Map<String, Object> additionalOpts) throws Exception {
        boolean useDefaultSslContext = ConfigurationHelper.getBooleanProperty("useDefaultSslContext", false, additionalOpts);
        if (useDefaultSslContext) {
            logger.debug("Using the Default JDK SSLContext.");
            return SSLContext.getDefault();
        }
        logger.debug("Creating JDK SSLContext with {}", (Object)config);
        return new SSLSupport(config).createContext();
    }

    @Override
    public int getPriority() {
        return 5;
    }
}

