/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jboss.marshalling.JDKSpecific;
import org.jboss.marshalling.UnmarshallingFilter;

final class SimpleUnmarshallingFilter
implements UnmarshallingFilter {
    private final List<Function<JDKSpecific.FilterInput, UnmarshallingFilter.FilterResponse>> unmarshallingFilters;

    SimpleUnmarshallingFilter(String filterSpec) {
        if (filterSpec == null) {
            throw new IllegalArgumentException("Parameter 'filterSpec' may not be null");
        }
        ArrayList<String> parsedFilterSpecs = new ArrayList<String>(Arrays.asList(filterSpec.split(";")));
        this.unmarshallingFilters = new ArrayList<Function<JDKSpecific.FilterInput, UnmarshallingFilter.FilterResponse>>(parsedFilterSpecs.size());
        ExactMatchFilter exactMatchAllowlist = null;
        ExactMatchFilter exactMatchDenylist = null;
        for (String spec : parsedFilterSpecs) {
            Function<JDKSpecific.FilterInput, UnmarshallingFilter.FilterResponse> filter;
            if (spec.contains("/")) {
                throw SimpleUnmarshallingFilter.invalidFilterSpec(spec);
            }
            int eqPos = spec.indexOf(61);
            if (eqPos > -1) {
                filter = this.parseLimitSpec(spec, eqPos);
            } else {
                filter = this.parseClassSpec(spec, exactMatchDenylist, exactMatchDenylist);
                if ((exactMatchAllowlist == null || exactMatchDenylist == null) && filter instanceof ExactMatchFilter) {
                    ExactMatchFilter exactMatch = (ExactMatchFilter)filter;
                    if (exactMatch.isForAllowlist()) {
                        exactMatchAllowlist = exactMatch;
                    } else {
                        exactMatchDenylist = exactMatch;
                    }
                }
            }
            if (filter == null) continue;
            this.unmarshallingFilters.add(filter);
        }
        if (this.unmarshallingFilters.size() == 0) {
            throw SimpleUnmarshallingFilter.invalidFilterSpec(filterSpec);
        }
    }

    private Function<JDKSpecific.FilterInput, UnmarshallingFilter.FilterResponse> parseLimitSpec(String spec, int eqPos) {
        Function<JDKSpecific.FilterInput, UnmarshallingFilter.FilterResponse> filter;
        long value;
        String type = spec.substring(0, eqPos);
        if (eqPos == spec.length() - 1) {
            throw SimpleUnmarshallingFilter.invalidFilterSpec(spec);
        }
        try {
            value = Long.parseLong(spec.substring(eqPos + 1));
        }
        catch (NumberFormatException e) {
            throw SimpleUnmarshallingFilter.invalidFilterSpec(spec, e);
        }
        if (value < 0L) {
            throw SimpleUnmarshallingFilter.invalidFilterSpec(spec);
        }
        switch (type) {
            case "maxdepth": {
                filter = input -> input.getDepth() > value ? UnmarshallingFilter.FilterResponse.REJECT : UnmarshallingFilter.FilterResponse.UNDECIDED;
                break;
            }
            case "maxarray": {
                filter = input -> input.getArrayLength() > value ? UnmarshallingFilter.FilterResponse.REJECT : UnmarshallingFilter.FilterResponse.UNDECIDED;
                break;
            }
            case "maxrefs": {
                filter = input -> input.getReferences() > value ? UnmarshallingFilter.FilterResponse.REJECT : UnmarshallingFilter.FilterResponse.UNDECIDED;
                break;
            }
            case "maxbytes": {
                filter = input -> input.getStreamBytes() > value ? UnmarshallingFilter.FilterResponse.REJECT : UnmarshallingFilter.FilterResponse.UNDECIDED;
                break;
            }
            default: {
                throw SimpleUnmarshallingFilter.invalidFilterSpec(spec);
            }
        }
        return filter;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function<JDKSpecific.FilterInput, UnmarshallingFilter.FilterResponse> parseClassSpec(String spec, ExactMatchFilter exactMatchDenylist, ExactMatchFilter exactMatchAllowlist) {
        void var4_13;
        int lastStar;
        UnmarshallingFilter.FilterResponse matchReturn;
        Object var4_4 = null;
        boolean denylistElement = spec.startsWith("!");
        UnmarshallingFilter.FilterResponse filterResponse = matchReturn = denylistElement ? UnmarshallingFilter.FilterResponse.REJECT : UnmarshallingFilter.FilterResponse.ACCEPT;
        if (denylistElement) {
            if (spec.length() == 1) {
                throw SimpleUnmarshallingFilter.invalidFilterSpec(spec);
            }
            spec = spec.substring(1);
        }
        if ((lastStar = spec.lastIndexOf(42)) >= 0) {
            if (lastStar != spec.length() - 1) {
                throw SimpleUnmarshallingFilter.invalidFilterSpec(spec);
            }
            int firstStar = spec.indexOf(42);
            if (firstStar != lastStar) {
                if (firstStar != lastStar - 1 || !spec.endsWith(".**")) throw SimpleUnmarshallingFilter.invalidFilterSpec(spec);
                if (spec.length() == 3) {
                    throw SimpleUnmarshallingFilter.invalidFilterSpec(spec);
                }
                String pkg = spec.substring(0, spec.length() - 2);
                Function<JDKSpecific.FilterInput, UnmarshallingFilter.FilterResponse> function = input -> SimpleUnmarshallingFilter.classNameFor(input).startsWith(pkg) ? matchReturn : UnmarshallingFilter.FilterResponse.UNDECIDED;
                return var4_13;
            } else if (spec.endsWith(".*")) {
                if (spec.length() == 2) {
                    throw SimpleUnmarshallingFilter.invalidFilterSpec(spec);
                }
                String pkg = spec.substring(0, spec.length() - 1);
                Function<JDKSpecific.FilterInput, UnmarshallingFilter.FilterResponse> function = input -> SimpleUnmarshallingFilter.classNameFor(input).startsWith(pkg) && SimpleUnmarshallingFilter.classNameFor(input).lastIndexOf(46) == pkg.length() - 1 ? matchReturn : UnmarshallingFilter.FilterResponse.UNDECIDED;
                return var4_13;
            } else {
                String startsWith = spec.substring(0, spec.length() - 1);
                Function<JDKSpecific.FilterInput, UnmarshallingFilter.FilterResponse> function = input -> SimpleUnmarshallingFilter.classNameFor(input).startsWith(startsWith) ? matchReturn : UnmarshallingFilter.FilterResponse.UNDECIDED;
            }
            return var4_13;
        } else if (denylistElement) {
            if (exactMatchDenylist == null) {
                ExactMatchFilter exactMatchFilter = exactMatchDenylist = new ExactMatchFilter(false);
            }
            exactMatchDenylist.addMatchingClass(spec);
            return var4_13;
        } else {
            if (exactMatchAllowlist == null) {
                ExactMatchFilter exactMatchFilter = exactMatchAllowlist = new ExactMatchFilter(true);
            }
            exactMatchAllowlist.addMatchingClass(spec);
        }
        return var4_13;
    }

    @Override
    public UnmarshallingFilter.FilterResponse checkInput(JDKSpecific.FilterInput input) {
        for (Function<JDKSpecific.FilterInput, UnmarshallingFilter.FilterResponse> func : this.unmarshallingFilters) {
            UnmarshallingFilter.FilterResponse response = func.apply(input);
            if (response == UnmarshallingFilter.FilterResponse.UNDECIDED) continue;
            return response;
        }
        return UnmarshallingFilter.FilterResponse.UNDECIDED;
    }

    private static String classNameFor(JDKSpecific.FilterInput input) {
        if (input.getUnmarshalledClass() == null) {
            return "";
        }
        return input.getUnmarshalledClass().getName();
    }

    private static IllegalArgumentException invalidFilterSpec(String spec) {
        return SimpleUnmarshallingFilter.invalidFilterSpec(spec, null);
    }

    private static IllegalArgumentException invalidFilterSpec(String spec, Throwable cause) {
        return new IllegalArgumentException(String.format("Invalid unmarshalling filter specification '%s'", spec), cause);
    }

    private static class ExactMatchFilter
    implements Function<JDKSpecific.FilterInput, UnmarshallingFilter.FilterResponse> {
        private final Set<String> matches = new HashSet<String>();
        private final UnmarshallingFilter.FilterResponse matchResult;

        private ExactMatchFilter(boolean forAllowlist) {
            this.matchResult = forAllowlist ? UnmarshallingFilter.FilterResponse.ACCEPT : UnmarshallingFilter.FilterResponse.REJECT;
        }

        private void addMatchingClass(String name) {
            this.matches.add(name);
        }

        private boolean isForAllowlist() {
            return this.matchResult == UnmarshallingFilter.FilterResponse.ACCEPT;
        }

        @Override
        public UnmarshallingFilter.FilterResponse apply(JDKSpecific.FilterInput input) {
            return this.matches.contains(SimpleUnmarshallingFilter.classNameFor(input)) ? this.matchResult : UnmarshallingFilter.FilterResponse.UNDECIDED;
        }
    }
}

