/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.dom.address;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DomainList
extends AbstractList<String>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> domains;

    public DomainList(List<String> domains, boolean dontCopy) {
        this.domains = domains != null ? (dontCopy ? domains : new ArrayList(domains)) : Collections.emptyList();
    }

    public DomainList(List<String> domains) {
        this(domains, false);
    }

    public DomainList(String ... domains) {
        this.domains = domains != null ? Arrays.asList(domains) : Collections.emptyList();
    }

    @Override
    public int size() {
        return this.domains.size();
    }

    @Override
    public String get(int index) {
        return this.domains.get(index);
    }

    public String toRouteString() {
        StringBuilder sb = new StringBuilder();
        for (String domain : this.domains) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("@");
            sb.append(domain);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toRouteString();
    }
}

