/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging;

import java.io.File;
import java.util.Collection;
import java.util.function.Consumer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessageListener;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.cursor.PageCursorProvider;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.RouteContextList;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.PageFullMessagePolicy;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.runnables.AtomicRunnable;

public interface PagingStore
extends ActiveMQComponent,
RefCountMessageListener {
    public SimpleString getAddress();

    public long getNumberOfPages();

    public long getCurrentWritingPage();

    public SimpleString getStoreName();

    public File getFolder();

    default public String getFolderName() {
        return this.getFolder().getName();
    }

    public AddressFullMessagePolicy getAddressFullMessagePolicy();

    public PageFullMessagePolicy getPageFullMessagePolicy();

    public Long getPageLimitMessages();

    public Long getPageLimitBytes();

    public void pageFull(PageSubscription var1);

    public boolean isPageFull();

    public void checkPageLimit(long var1);

    public long getFirstPage();

    public int getPageSizeBytes();

    public long getAddressSize();

    public long getMaxSize();

    public int getMaxPageReadBytes();

    public int getMaxPageReadMessages();

    public int getPrefetchPageBytes();

    public int getPrefetchPageMessages();

    public void applySetting(AddressSettings var1);

    public boolean isPaging();

    public void addSyncPoint(OperationContext var1) throws Exception;

    public void ioSync() throws Exception;

    public boolean page(Message var1, Transaction var2, RouteContextList var3) throws Exception;

    public Page usePage(long var1);

    public Page usePage(long var1, boolean var3);

    public Page newPageObject(long var1) throws Exception;

    public boolean checkPageFileExists(long var1) throws Exception;

    public PagingManager getPagingManager();

    public PageCursorProvider getCursorProvider();

    public void processReload() throws Exception;

    public Page depage() throws Exception;

    public Page removePage(int var1);

    public void forceAnotherPage() throws Exception;

    public Page getCurrentPage();

    public void counterSnapshot();

    public boolean startPaging() throws Exception;

    public void stopPaging() throws Exception;

    public void addSize(int var1, boolean var2);

    default public void addSize(int size) {
        this.addSize(size, false);
    }

    public boolean checkMemory(Runnable var1, Consumer<AtomicRunnable> var2);

    public boolean checkMemory(boolean var1, Runnable var2, Runnable var3, Consumer<AtomicRunnable> var4);

    public boolean isFull();

    public boolean isRejectingMessages();

    public boolean checkReleasedMemory();

    public boolean lock(long var1);

    public void unlock();

    public void flushExecutors();

    public void execute(Runnable var1);

    public ArtemisExecutor getExecutor();

    public Collection<Integer> getCurrentIds() throws Exception;

    public void sendPages(ReplicationManager var1, Collection<Integer> var2) throws Exception;

    public void disableCleanup();

    public void enableCleanup();

    public void destroy() throws Exception;

    public int getAddressLimitPercent();

    public void block();

    public void unblock();

    default public StorageManager getStorageManager() {
        return null;
    }
}

