/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.config;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.persistence.config.AbstractPersistedAddressSetting;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;

public class PersistedAddressSetting
extends AbstractPersistedAddressSetting
implements EncodingSupport {
    public PersistedAddressSetting() {
    }

    public String toString() {
        return "PersistedAddressSetting [storeId=" + this.storeId + ", addressMatch=" + this.addressMatch + ", setting=" + this.setting + "]";
    }

    public PersistedAddressSetting(SimpleString addressMatch, AddressSettings setting) {
        super(addressMatch, setting);
    }

    public void decode(ActiveMQBuffer buffer) {
        this.addressMatch = buffer.readSimpleString();
        this.setting = new AddressSettings();
        this.setting.decode(buffer);
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.addressMatch);
        this.setting.encode(buffer);
    }

    public int getEncodeSize() {
        return this.addressMatch.sizeof() + this.setting.getEncodeSize();
    }
}

