/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.algorithm;

public enum KeyEncryptionAlgorithm {
    RSA_OAEP("RSA-OAEP"),
    RSA_OAEP_256("RSA-OAEP-256"),
    ECDH_ES("ECDH-ES"),
    ECDH_ES_A128KW("ECDH-ES+128KW"),
    ECDH_ES_A192KW("ECDH-ES+192KW"),
    ECDH_ES_A256KW("ECDH-ES+A256KW"),
    A128KW("A128KW"),
    A192KW("A192KW"),
    A256KW("A256KW"),
    A128GCMKW("A128GCMKW"),
    A192GCMKW("A192GCMKW"),
    A256GCMKW("A256GCMKW"),
    PBES2_HS256_A128KW("PBES2-HS256+A128KW"),
    PBES2_HS384_A192KW("PBES2-HS384+A192KW"),
    PBES2_HS512_A256KW("PBES2-HS512+A256KW");

    private String algorithmName;

    private KeyEncryptionAlgorithm(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public String getAlgorithm() {
        return this.algorithmName;
    }

    public static KeyEncryptionAlgorithm fromAlgorithm(String algorithmName) {
        return KeyEncryptionAlgorithm.valueOf(algorithmName.replaceAll("-", "_").replaceAll("\\+", "_"));
    }
}

