/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.federation.internal;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerConsumerPlugin;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumer;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromQueuePolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationConsumerEntry;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationConsumerInternal;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationGenericConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FederationQueuePolicyManager
implements ActiveMQServerConsumerPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final ActiveMQServer server;
    protected final Predicate<ServerConsumer> federationConsumerMatcher;
    protected final FederationReceiveFromQueuePolicy policy;
    protected final Map<FederationConsumerInfo, FederationConsumerEntry> remoteConsumers = new HashMap<FederationConsumerInfo, FederationConsumerEntry>();
    protected final FederationInternal federation;
    private volatile boolean started;

    public FederationQueuePolicyManager(FederationInternal federation, FederationReceiveFromQueuePolicy queuePolicy) throws ActiveMQException {
        Objects.requireNonNull(federation, "The Federation instance cannot be null");
        Objects.requireNonNull(queuePolicy, "The Queue match policy cannot be null");
        this.federation = federation;
        this.policy = queuePolicy;
        this.server = federation.getServer();
        this.federationConsumerMatcher = this.createFederationConsumerMatcher(this.server, queuePolicy);
    }

    public synchronized void start() {
        if (!this.started) {
            this.started = true;
            this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)this);
            this.scanAllQueueBindings();
        }
    }

    public synchronized void stop() {
        if (this.started) {
            this.server.unRegisterBrokerPlugin((ActiveMQServerBasePlugin)this);
            this.started = false;
            this.remoteConsumers.forEach((k, v) -> v.getConsumer().close());
            this.remoteConsumers.clear();
        }
    }

    public synchronized void afterCreateConsumer(ServerConsumer consumer) {
        if (this.started) {
            this.reactIfConsumerMatchesPolicy(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void beforeCloseConsumer(ServerConsumer consumer, boolean failed) {
        FederationConsumerInfo consumerInfo;
        FederationConsumerEntry entry;
        if (this.started && (entry = this.remoteConsumers.get(consumerInfo = this.createConsumerInfo(consumer))) != null && entry.reduceDemand()) {
            FederationConsumerInternal federationConsuner = entry.getConsumer();
            try {
                this.signalBeforeCloseFederationConsumer(federationConsuner);
                federationConsuner.close();
                this.signalAfterCloseFederationConsumer(federationConsuner);
            }
            finally {
                this.remoteConsumers.remove(consumerInfo);
            }
        }
    }

    protected final void scanAllQueueBindings() {
        this.server.getPostOffice().getAllBindings().filter(b -> b instanceof QueueBinding).map(b -> (QueueBinding)b).forEach(b -> this.checkQueueForMatch(b.getQueue()));
    }

    protected final void checkQueueForMatch(Queue queue) {
        queue.getConsumers().stream().filter(consumer -> consumer instanceof ServerConsumer).map(c -> (ServerConsumer)c).forEach(this::reactIfConsumerMatchesPolicy);
    }

    protected final void reactIfConsumerMatchesPolicy(ServerConsumer consumer) {
        if (this.testIfQueueMatchesPolicy(consumer.getQueueAddress().toString(), consumer.getQueueName().toString())) {
            if (this.federationConsumerMatcher.test(consumer)) {
                return;
            }
            if (this.isPluginBlockingFederationConsumerCreate(consumer.getQueue())) {
                return;
            }
            logger.trace("Federation Policy matched on consumer for binding: {}", (Object)consumer.getBinding());
            FederationConsumerInfo consumerInfo = this.createConsumerInfo(consumer);
            if (this.remoteConsumers.containsKey(consumerInfo)) {
                this.remoteConsumers.get(consumerInfo).addDemand();
            } else {
                this.signalBeforeCreateFederationConsumer(consumerInfo);
                FederationConsumerInternal queueConsumer = this.createFederationConsumer(consumerInfo);
                FederationConsumerEntry entry = this.createConsumerEntry(queueConsumer);
                queueConsumer.setRemoteClosedHandler(closedConsumer -> {
                    FederationQueuePolicyManager federationQueuePolicyManager = this;
                    synchronized (federationQueuePolicyManager) {
                        try {
                            this.remoteConsumers.remove(closedConsumer.getConsumerInfo());
                        }
                        finally {
                            closedConsumer.close();
                        }
                    }
                });
                this.remoteConsumers.put(consumerInfo, entry);
                queueConsumer.start();
                this.signalAfterCreateFederationConsumer(queueConsumer);
            }
        }
    }

    protected boolean testIfQueueMatchesPolicy(String address, String queueName) {
        return this.policy.test(address, queueName);
    }

    protected FederationConsumerInfo createConsumerInfo(ServerConsumer consumer) {
        return FederationGenericConsumerInfo.build(consumer, this.federation, this.policy);
    }

    protected FederationConsumerEntry createConsumerEntry(FederationConsumerInternal consumer) {
        return new FederationConsumerEntry(consumer);
    }

    protected abstract FederationConsumerInternal createFederationConsumer(FederationConsumerInfo var1);

    protected Predicate<ServerConsumer> createFederationConsumerMatcher(ActiveMQServer server, FederationReceiveFromQueuePolicy policy) throws ActiveMQException {
        if (policy.isIncludeFederated()) {
            return consumer -> false;
        }
        Filter metaDataMatcher = FilterImpl.createFilter((String)"\"federation-name\" IS NOT NULL");
        return consumer -> {
            ServerSession serverSession = server.getSessionByID(consumer.getSessionID());
            if (serverSession != null && serverSession.getMetaData() != null) {
                return metaDataMatcher.match(serverSession.getMetaData());
            }
            return false;
        };
    }

    protected abstract void signalBeforeCreateFederationConsumer(FederationConsumerInfo var1);

    protected abstract void signalAfterCreateFederationConsumer(FederationConsumer var1);

    protected abstract void signalBeforeCloseFederationConsumer(FederationConsumer var1);

    protected abstract void signalAfterCloseFederationConsumer(FederationConsumer var1);

    protected abstract boolean isPluginBlockingFederationConsumerCreate(Queue var1);
}

