/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.util.AbstractMap;
import java.util.Map;
import org.wildfly.clustering.web.cache.session.CompositeImmutableSession;
import org.wildfly.clustering.web.cache.session.ImmutableSessionFactory;
import org.wildfly.clustering.web.cache.session.attributes.ImmutableSessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.metadata.ImmutableSessionMetaDataFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class CompositeImmutableSessionFactory<MV, AV>
implements ImmutableSessionFactory<MV, AV> {
    private final ImmutableSessionMetaDataFactory<MV> metaDataFactory;
    private final ImmutableSessionAttributesFactory<AV> attributesFactory;

    public CompositeImmutableSessionFactory(ImmutableSessionMetaDataFactory<MV> metaDataFactory, ImmutableSessionAttributesFactory<AV> attributesFactory) {
        this.metaDataFactory = metaDataFactory;
        this.attributesFactory = attributesFactory;
    }

    public Map.Entry<MV, AV> findValue(String id) {
        Object attributesValue;
        Object metaDataValue = this.metaDataFactory.findValue(id);
        if (metaDataValue != null && (attributesValue = this.attributesFactory.findValue(id)) != null) {
            return new AbstractMap.SimpleImmutableEntry<Object, Object>(metaDataValue, attributesValue);
        }
        return null;
    }

    public Map.Entry<MV, AV> tryValue(String id) {
        Object attributesValue;
        Object metaDataValue = this.metaDataFactory.tryValue(id);
        if (metaDataValue != null && (attributesValue = this.attributesFactory.tryValue(id)) != null) {
            return new AbstractMap.SimpleImmutableEntry<Object, Object>(metaDataValue, attributesValue);
        }
        return null;
    }

    @Override
    public ImmutableSessionMetaDataFactory<MV> getMetaDataFactory() {
        return this.metaDataFactory;
    }

    @Override
    public ImmutableSessionAttributesFactory<AV> getAttributesFactory() {
        return this.attributesFactory;
    }

    @Override
    public ImmutableSession createImmutableSession(String id, ImmutableSessionMetaData metaData, ImmutableSessionAttributes attributes) {
        return new CompositeImmutableSession(id, metaData, attributes);
    }
}

