/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.attributes.fine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.clustering.web.cache.session.attributes.fine.SessionAttributeActivationNotifier;
import org.wildfly.clustering.web.session.HttpSessionActivationListenerProvider;
import org.wildfly.clustering.web.session.ImmutableSession;

public class ImmutableSessionAttributeActivationNotifier<S, C, L>
implements SessionAttributeActivationNotifier {
    private final Function<Supplier<L>, L> prePassivateListenerFactory;
    private final Function<Supplier<L>, L> postActivateListenerFactory;
    private final HttpSessionActivationListenerProvider<S, C, L> provider;
    private final Function<L, Consumer<S>> prePassivateNotifier;
    private final Function<L, Consumer<S>> postActivateNotifier;
    private final S session;
    private final Map<Supplier<L>, L> listeners = new ConcurrentHashMap<Supplier<L>, L>();

    public ImmutableSessionAttributeActivationNotifier(HttpSessionActivationListenerProvider<S, C, L> provider, ImmutableSession session, C context) {
        this.provider = provider;
        this.prePassivateNotifier = arg_0 -> this.provider.prePassivateNotifier(arg_0);
        this.postActivateNotifier = arg_0 -> this.provider.postActivateNotifier(arg_0);
        this.prePassivateListenerFactory = new HttpSessionActivationListenerFactory<S, C, L>(provider, true);
        this.postActivateListenerFactory = new HttpSessionActivationListenerFactory<S, C, L>(provider, false);
        this.session = provider.createHttpSession(session, context);
    }

    @Override
    public void prePassivate(Object object) {
        this.notify(object, this.prePassivateListenerFactory, this.prePassivateNotifier);
    }

    @Override
    public void postActivate(Object object) {
        this.notify(object, this.postActivateListenerFactory, this.postActivateNotifier);
    }

    private void notify(Object object, Function<Supplier<L>, L> listenerFactory, Function<L, Consumer<S>> notifierFactory) {
        Class listenerClass = this.provider.getHttpSessionActivationListenerClass();
        if (listenerClass.isInstance(object)) {
            HttpSessionActivationListenerKey reference = new HttpSessionActivationListenerKey(listenerClass.cast(object));
            L listener = this.listeners.computeIfAbsent(reference, listenerFactory);
            notifierFactory.apply(listener).accept(this.session);
        }
    }

    @Override
    public void close() {
        for (L listener : this.listeners.values()) {
            this.provider.prePassivateNotifier(listener).accept(this.session);
        }
        this.listeners.clear();
    }

    private static class HttpSessionActivationListenerFactory<S, C, L>
    implements Function<Supplier<L>, L> {
        private final HttpSessionActivationListenerProvider<S, C, L> provider;
        private final boolean active;

        HttpSessionActivationListenerFactory(HttpSessionActivationListenerProvider<S, C, L> provider, boolean active) {
            this.provider = provider;
            this.active = active;
        }

        @Override
        public L apply(Supplier<L> reference) {
            final HttpSessionActivationListenerProvider<S, C, L> provider = this.provider;
            final L listener = reference.get();
            final AtomicBoolean active = new AtomicBoolean(this.active);
            Consumer prePassivate = new Consumer<S>(){

                @Override
                public void accept(S session) {
                    if (active.compareAndSet(true, false)) {
                        provider.prePassivateNotifier(listener).accept(session);
                    }
                }
            };
            Consumer postActivate = new Consumer<S>(){

                @Override
                public void accept(S session) {
                    if (active.compareAndSet(false, true)) {
                        provider.postActivateNotifier(listener).accept(session);
                    }
                }
            };
            return (L)provider.createListener(prePassivate, postActivate);
        }
    }

    private static class HttpSessionActivationListenerKey<L>
    implements Supplier<L> {
        private final L listener;

        HttpSessionActivationListenerKey(L listener) {
            this.listener = listener;
        }

        @Override
        public L get() {
            return this.listener;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof HttpSessionActivationListenerKey)) {
                return false;
            }
            HttpSessionActivationListenerKey reference = (HttpSessionActivationListenerKey)object;
            return this.listener == reference.listener;
        }
    }
}

